/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime.attachments;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.message.SoapResponse;
import org.mule.soap.api.transport.TransportResponse;
import org.mule.soap.internal.message.DefaultSoapRequest;

public class AttachmentsTestCase
extends AbstractSoapServiceTestCase {
    @Test
    public void downloadAttachment() throws Exception {
        DefaultSoapRequest req = SoapRequest.builder().content(this.testValues.getDownloadAttachmentRequest()).operation("downloadAttachment").build();
        SoapResponse response = this.client.consume((SoapRequest)req, null);
        this.assertDownloadAttachment(response);
    }

    @Test
    public void uploadAttachment() throws Exception {
        DefaultSoapRequest request = SoapRequest.builder().attachment("attachment", new SoapAttachment((InputStream)new ByteArrayInputStream("Some Content".getBytes()), "text/html")).content(this.testValues.getUploadAttachmentRequest()).operation("uploadAttachment").build();
        SoapResponse response = this.client.consume((SoapRequest)request, null);
        this.assertUploadAttachment(response);
    }

    @Test
    public void downloadAttachmentReply() throws Exception {
        TransportResponse transportResponse = this.getDownloadAttachmentResponse();
        SoapResponse response = this.client.parseResponse("downloadAttachment", transportResponse);
        this.assertDownloadAttachment(response);
    }

    @Test
    public void uploadAttachmentReply() throws Exception {
        ImmutableMap transportHeaders = ImmutableMap.builder().put((Object)"Content-Type", (Object)"text/xml").build();
        TransportResponse transportResponse = new TransportResponse((InputStream)new ByteArrayInputStream(this.testValues.getUploadAttachmentFullResponse().getBytes()), (Map)transportHeaders);
        SoapResponse response = this.client.parseResponse("uploadAttachment", transportResponse);
        this.assertUploadAttachment(response);
    }

    protected TransportResponse getDownloadAttachmentResponse() {
        ImmutableMap transportHeaders = ImmutableMap.builder().put((Object)"Content-Type", (Object)"text/xml;charset=iso-8859-1").build();
        String response = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns2:downloadAttachmentResponse xmlns:ns2=\"http://service.soap.mule.org/\"><attachment>U2ltcGxlIEF0dGFjaG1lbnQgQ29udGVudAo=</attachment></ns2:downloadAttachmentResponse></soap:Body></soap:Envelope>";
        return new TransportResponse((InputStream)new ByteArrayInputStream(response.getBytes()), (Map)transportHeaders);
    }

    private void assertDownloadAttachment(SoapResponse response) throws Exception {
        SoapTestUtils.assertSimilarXml(this.testValues.getDownloadAttachmentResponse(), response.getContent());
        Map attachments = response.getAttachments();
        Assert.assertThat(attachments.entrySet(), (Matcher)Matchers.hasSize((int)1));
        SoapAttachment attachment = (SoapAttachment)attachments.entrySet().iterator().next().getValue();
        Assert.assertThat((Object)IOUtils.toString((InputStream)attachment.getContent()), (Matcher)Matchers.containsString((String)"Simple Attachment Content"));
    }

    private void assertUploadAttachment(SoapResponse response) throws Exception {
        SoapTestUtils.assertSimilarXml(this.testValues.getUploadAttachmentResponse(), response.getContent());
    }
}

