/*
 * Decompiled with CFR 0.152.
 */
package org.mule.consulting.eframework.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.inject.Inject;
import org.mule.consulting.eframework.api.error.CircuitBreakerOpenException;
import org.mule.consulting.eframework.api.error.EframeworkErrorProvider;
import org.mule.consulting.eframework.internal.EframeworkConfiguration;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EframeworkOperations {
    public static String NOTIFICATION_FLOWNAME = "eframework.notificationFlow";
    public static String ERROR_FLOWNAME = "eframework.errorTransactionFlow";
    public static String RETRY_FLOWNAME = "eframework.retryTransactionFlow";
    public static String AUDIT_FLOWNAME = "eframework.auditLogFlow";
    public static String RESPONSE_PAYLOAD_FLOWNAME = "eframework.responsePayloadLogFlow";
    public static String REQUEST_PAYLOAD_FLOWNAME = "eframework.requestPayloadLogFlow";
    public static String BUSINESS_EVENT_FLOWNAME = "eframework.businessEventFlow";
    public static String SYSTEM_EVENT_FLOWNAME = "eframework.systemEventFlow";
    public static String CIRCUIT_BREAKER_CHECK_FLOWNAME = "eframework.circuitbreaker-check-breaker";
    public static String CIRCUIT_BREAKER_TRIP_FLOWNAME = "eframework.circuitbreaker-trip";
    public static String CIRCUIT_BREAKER_RESET_FLOWNAME = "eframework.circuitbreaker-reset";
    public static String CIRCUIT_BREAKER_AUTO_CHECK_FLOWNAME = "eframework.circuitbreaker-auto-check-breaker";
    public static String CIRCUIT_BREAKER_AUTO_TRIP_FLOWNAME = "eframework.circuitbreaker-auto-trip";
    public static String CIRCUIT_BREAKER_AUTO_RESET_FLOWNAME = "eframework.circuitbreaker-auto-reset";
    private final Logger LOGGER = LoggerFactory.getLogger(EframeworkOperations.class);
    @Inject
    private Registry muleRegistry;

    @MediaType(value="*/*", strict=false)
    public Map<String, String> put(String key, String value, @org.mule.runtime.extension.api.annotation.param.Optional Map<String, String> transactionProperties, ComponentLocation location) {
        TreeMap<String, String> tempMap = new TreeMap<String, String>();
        if (transactionProperties != null) {
            tempMap.putAll(transactionProperties);
        }
        tempMap.put(key, value);
        return tempMap;
    }

    @MediaType(value="*/*", strict=false)
    public Map<String, String> putAll(Map<String, String> newProperties, @org.mule.runtime.extension.api.annotation.param.Optional Map<String, String> transactionProperties, ComponentLocation location) {
        TreeMap<String, String> tempMap = new TreeMap<String, String>();
        if (transactionProperties != null) {
            tempMap.putAll(transactionProperties);
        }
        tempMap.putAll(newProperties);
        return tempMap;
    }

    @Alias(value="businessEvent")
    public void generateBusinessEvent(String eventType, String eventStatus, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="BUSINESS EVENT: ") String eventMsg, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[{}]") @ParameterDsl(allowInlineDefinition=false) Map<String, String> attributes, @Content Object content, ComponentLocation location, @Config EframeworkConfiguration config) {
        this.createEventAttributesCallFlow(BUSINESS_EVENT_FLOWNAME, eventType, eventStatus, eventMsg, attributes, content, location, config);
    }

    @Alias(value="systemEvent")
    public void generateSystemEvent(String eventType, String eventStatus, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="SYSTEM EVENT: ") String eventMsg, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[{}]") @ParameterDsl(allowInlineDefinition=false) Map<String, String> attributes, @Content Object content, ComponentLocation location, @Config EframeworkConfiguration config) {
        this.createEventAttributesCallFlow(SYSTEM_EVENT_FLOWNAME, eventType, eventStatus, eventMsg, attributes, content, location, config);
    }

    @Alias(value="sendNotificationEvent")
    public void generateNotificationEvent(String transactionType, String transactionStatus, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="NOTIFICATION: ") String transactionMsg, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[{}]") @ParameterDsl(allowInlineDefinition=false) Map<String, String> attributes, @Content Object content, ComponentLocation location, @Config EframeworkConfiguration config) {
        this.createAttributesCallFlow(NOTIFICATION_FLOWNAME, transactionType, transactionStatus, transactionMsg, attributes, content, location, config);
    }

    @Alias(value="sendErrorEvent")
    public void generateErrorEvent(String transactionType, String transactionStatus, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="ERROR: ") String transactionMsg, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[{}]") @ParameterDsl(allowInlineDefinition=false) Map<String, String> attributes, @Content Object content, ComponentLocation location, @Config EframeworkConfiguration config) {
        this.createAttributesCallFlow(ERROR_FLOWNAME, transactionType, transactionStatus, transactionMsg, attributes, content, location, config);
    }

    @Alias(value="sendRetryEvent")
    public void generateRetryEvent(String transactionType, String transactionStatus, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="RETRY: ") String transactionMsg, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[{}]") @ParameterDsl(allowInlineDefinition=false) Map<String, String> attributes, @Content Object content, ComponentLocation location, @Config EframeworkConfiguration config) {
        this.createAttributesCallFlow(RETRY_FLOWNAME, transactionType, transactionStatus, transactionMsg, attributes, content, location, config);
    }

    @Alias(value="sendAuditEvent")
    public void generateAuditEvent(String transactionType, String transactionStatus, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="AUDIT: ") String transactionMsg, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[{}]") @ParameterDsl(allowInlineDefinition=false) Map<String, String> attributes, @Content Object content, ComponentLocation location, @Config EframeworkConfiguration config) {
        this.createAttributesCallFlow(AUDIT_FLOWNAME, transactionType, transactionStatus, transactionMsg, attributes, content, location, config);
    }

    public void logResponsePayload(String transactionType, String transactionStatus, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="RESPONSE Payload: ") String transactionMsg, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[{}]") @ParameterDsl(allowInlineDefinition=false) Map<String, String> attributes, @Content Object content, ComponentLocation location, @Config EframeworkConfiguration config) {
        TreeMap<String, String> tempMap = this.createAttributes(transactionType, transactionStatus, transactionMsg, attributes, location, config);
        tempMap.put("transactionMsg", transactionMsg);
        tempMap.put("payloadType", "RESPONSE");
        this.callFlow(RESPONSE_PAYLOAD_FLOWNAME, tempMap, content, location, config);
    }

    public void logRequestPayload(String transactionType, String transactionStatus, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="REQUEST Payload: ") String transactionMsg, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[{}]") @ParameterDsl(allowInlineDefinition=false) Map<String, String> attributes, @Content Object content, ComponentLocation location, @Config EframeworkConfiguration config) {
        TreeMap<String, String> tempMap = this.createAttributes(transactionType, transactionStatus, transactionMsg, attributes, location, config);
        tempMap.put("transactionMsg", transactionMsg);
        tempMap.put("payloadType", "REQUEST");
        this.callFlow(REQUEST_PAYLOAD_FLOWNAME, tempMap, content, location, config);
    }

    @Throws(value={EframeworkErrorProvider.class})
    public void circuitBreakerOpenError(String transactionType, String transactionStatus, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="Circuit Breaker Open Error: ") String transactionMsg, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[{}]") @ParameterDsl(allowInlineDefinition=false) Map<String, String> attributes, @Content Object content, ComponentLocation location, @Config EframeworkConfiguration config) {
        TreeMap<String, String> tempMap = this.createAttributes(transactionType, transactionStatus, transactionMsg, attributes, location, config);
        throw new CircuitBreakerOpenException(tempMap.get("transactionMsg"));
    }

    public void circuitBreakerCheck(String transactionType, String transactionStatus, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="Check Circuit Breaker: ") String transactionMsg, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[{}]") @ParameterDsl(allowInlineDefinition=false) Map<String, String> attributes, @Content Object content, ComponentLocation location, @Config EframeworkConfiguration config) {
        this.createAttributesCallFlow(CIRCUIT_BREAKER_CHECK_FLOWNAME, transactionType, transactionStatus, transactionMsg, attributes, content, location, config);
    }

    @Throws(value={EframeworkErrorProvider.class})
    public void circuitBreakerTrip(String transactionType, String transactionStatus, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="Trip Circuit Breaker: ") String transactionMsg, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="TRUE") boolean throwError, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[{}]") @ParameterDsl(allowInlineDefinition=false) Map<String, String> attributes, @Content Object content, ComponentLocation location, @Config EframeworkConfiguration config) {
        TreeMap<String, String> tempMap = this.createAttributes(transactionType, transactionStatus, transactionMsg, attributes, location, config);
        this.callFlow(CIRCUIT_BREAKER_TRIP_FLOWNAME, tempMap, content, location, config);
        if (throwError) {
            throw new CircuitBreakerOpenException(tempMap.get("transactionMsg"));
        }
    }

    public void circuitBreakerReset(String transactionType, String transactionStatus, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="Reset Circuit Breaker: ") String transactionMsg, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[{}]") @ParameterDsl(allowInlineDefinition=false) Map<String, String> attributes, @Content Object content, ComponentLocation location, @Config EframeworkConfiguration config) {
        this.createAttributesCallFlow(CIRCUIT_BREAKER_RESET_FLOWNAME, transactionType, transactionStatus, transactionMsg, attributes, content, location, config);
    }

    public void circuitBreakerAutoCheck(String transactionType, String transactionStatus, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="Check Auto Circuit Breaker: ") String transactionMsg, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[{}]") @ParameterDsl(allowInlineDefinition=false) Map<String, String> attributes, @Content Object content, ComponentLocation location, @Config EframeworkConfiguration config) {
        this.createAttributesCallFlow(CIRCUIT_BREAKER_AUTO_CHECK_FLOWNAME, transactionType, transactionStatus, transactionMsg, attributes, content, location, config);
    }

    @Throws(value={EframeworkErrorProvider.class})
    public void circuitBreakerAutoTrip(String transactionType, String transactionStatus, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="Trip Auto Circuit Breaker: ") String transactionMsg, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="TRUE") boolean throwError, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[{}]") @ParameterDsl(allowInlineDefinition=false) Map<String, String> attributes, @Content Object content, ComponentLocation location, @Config EframeworkConfiguration config) {
        TreeMap<String, String> tempMap = this.createAttributes(transactionType, transactionStatus, transactionMsg, attributes, location, config);
        this.callFlow(CIRCUIT_BREAKER_AUTO_TRIP_FLOWNAME, tempMap, content, location, config);
        if (throwError) {
            throw new CircuitBreakerOpenException(tempMap.get("transactionMsg"));
        }
    }

    public void circuitBreakerAutoReset(String transactionType, String transactionStatus, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="Reset Auto Circuit Breaker: ") String transactionMsg, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[{}]") @ParameterDsl(allowInlineDefinition=false) Map<String, String> attributes, @Content Object content, ComponentLocation location, @Config EframeworkConfiguration config) {
        this.createAttributesCallFlow(CIRCUIT_BREAKER_AUTO_RESET_FLOWNAME, transactionType, transactionStatus, transactionMsg, attributes, content, location, config);
    }

    private void createAttributesCallFlow(String flowName, String transactionType, String transactionStatus, String transactionMsg, Map<String, String> attributes, Object content, ComponentLocation location, EframeworkConfiguration config) {
        TreeMap<String, String> tempMap = this.createAttributes(transactionType, transactionStatus, transactionMsg, attributes, location, config);
        this.callFlow(flowName, tempMap, content, location, config);
    }

    private TreeMap<String, String> createAttributes(String transactionType, String transactionStatus, String transactionMsg, Map<String, String> attributes, ComponentLocation location, EframeworkConfiguration config) {
        TreeMap<String, String> tempMap = new TreeMap<String, String>();
        if (attributes != null) {
            for (String item : attributes.keySet()) {
                tempMap.put(item, attributes.get(item));
            }
        }
        this.addLocation(tempMap, location);
        tempMap.put("applicationId", config.getApplicationId());
        tempMap.put("transactionType", transactionType);
        tempMap.put("transactionStatus", transactionStatus);
        String strMsg = this.formatMsg(transactionMsg, tempMap);
        tempMap.put("transactionMsg", strMsg);
        return tempMap;
    }

    private void createEventAttributesCallFlow(String flowName, String eventType, String eventStatus, String eventMsg, Map<String, String> attributes, Object content, ComponentLocation location, EframeworkConfiguration config) {
        TreeMap<String, String> tempMap = this.createEventAttributes(eventType, eventStatus, eventMsg, attributes, location, config);
        this.callFlow(flowName, tempMap, content, location, config);
    }

    private TreeMap<String, String> createEventAttributes(String eventType, String eventStatus, String eventMsg, Map<String, String> attributes, ComponentLocation location, EframeworkConfiguration config) {
        TreeMap<String, String> tempMap = new TreeMap<String, String>();
        if (attributes != null) {
            for (String item : attributes.keySet()) {
                tempMap.put(item, attributes.get(item));
            }
        }
        this.addLocation(tempMap, location);
        tempMap.put("applicationId", config.getApplicationId());
        tempMap.put("eventType", eventType);
        tempMap.put("eventStatus", eventStatus);
        String strMsg = this.formatMsg(eventMsg, tempMap);
        tempMap.put("eventMsg", strMsg);
        return tempMap;
    }

    private void callFlow(String flowName, TreeMap<String, String> tempMap, Object content, ComponentLocation location, EframeworkConfiguration config) {
        try {
            Flow flow = this.lookupFlow(flowName);
            if (flow != null) {
                Message msg = Message.builder().value(content).attributesValue(tempMap).build();
                CoreEvent event = CoreEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)flow, (ComponentLocation)location)).message(msg).build();
                flow.process(event);
            } else {
                this.LOGGER.warn(flowName + " does not exist: ");
            }
        }
        catch (MuleException ex) {
            this.LOGGER.error("Error during " + tempMap.get("transactionType"), (Throwable)ex);
        }
    }

    private void addLocation(Map<String, String> transactionProperties, ComponentLocation location) {
        if (location != null) {
            Optional fileName = location.getFileName();
            Optional lineNumber = location.getLineInFile();
            transactionProperties.put("event.flow", location.getRootContainerName());
            if (fileName.isPresent()) {
                transactionProperties.put("event.fileName", (String)fileName.get());
            }
            if (lineNumber.isPresent()) {
                transactionProperties.put("event.lineNumber", ((Integer)lineNumber.get()).toString());
            }
        } else {
            this.LOGGER.debug("Missing location information");
        }
    }

    private String formatMsg(String msg, Map<String, String> transactionProperties) {
        ObjectMapper mapper = new ObjectMapper();
        String payload = "";
        try {
            if (transactionProperties != null) {
                payload = mapper.writeValueAsString(transactionProperties);
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(msg).append(" ").append(payload);
        return sb.toString();
    }

    private Flow lookupFlow(String flowName) {
        return this.muleRegistry.lookupByName(flowName).orElse(null);
    }
}

