/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.mule.api.vcs.cli.ApiClientFactory;
import org.mule.api.vcs.cli.BaseCommand;
import org.mule.api.vcs.cli.Lazy;
import org.mule.api.vcs.cli.exceptions.ConfigurationException;
import org.mule.api.vcs.client.service.UserInfoProvider;
import org.mule.cs.exceptions.CoreServicesAPIReferenceException;
import org.mule.cs.resource.api.me.model.MeGETResponseBody;
import org.mule.cs.resource.login.model.LoginPOSTBody;
import org.mule.cs.resource.login.model.LoginPOSTResponseBody;
import org.mule.cs.responses.CoreServicesAPIReferenceResponse;
import picocli.CommandLine;

public class BaseAuthorizedCommand
extends BaseCommand {
    @CommandLine.Option(names={"-u", "--username"}, description={"The username to be used to log into our platform."})
    private String userName;
    @CommandLine.Option(names={"-p", "--password"}, description={"The username to be used to log into our platform."})
    private String password;
    @CommandLine.Option(names={"-o", "--organization"}, description={"The username to be used to log into our platform."})
    private String organization;
    private ApiVCSConfig globalConfig;

    public UserInfoProvider getAccessTokenProvider() {
        Optional<ApiVCSConfig> globalConfig = this.getGlobalConfig();
        Lazy<String> userId = Lazy.lazily(() -> {
            if (this.userName != null) {
                return this.userName;
            }
            if (globalConfig.isPresent() && ((ApiVCSConfig)globalConfig.get()).getUserName().isPresent()) {
                return ((ApiVCSConfig)globalConfig.get()).getUserName().get();
            }
            throw new ConfigurationException("Missing --username parameter.");
        });
        Lazy<String> password = Lazy.lazily(() -> {
            if (this.password != null) {
                return this.password;
            }
            if (globalConfig.isPresent() && ((ApiVCSConfig)globalConfig.get()).getPassword().isPresent()) {
                return ((ApiVCSConfig)globalConfig.get()).getPassword().get();
            }
            throw new ConfigurationException("Missing --password parameter");
        });
        String orgId = null;
        if (this.organization != null) {
            orgId = this.organization;
        } else if (globalConfig.isPresent() && globalConfig.get().getOrganization().isPresent()) {
            orgId = globalConfig.get().getOrganization().get();
        }
        return new CoreServicesUserInfoProvider(userId, password, orgId);
    }

    private Optional<ApiVCSConfig> getGlobalConfig() {
        File configFile;
        String property = System.getProperty("user.home");
        File globalConfig = new File(property, ".apivcs");
        if (globalConfig.isDirectory() && (configFile = new File(globalConfig, "config.properties")).isFile()) {
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(configFile));
                return Optional.of(new ApiVCSConfig(properties.getProperty("username"), properties.getProperty("password"), properties.getProperty("baseUrl"), properties.getProperty("orgId")));
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    class ApiVCSConfig {
        private String userName;
        private String password;
        private String organization;
        private String baseUrl;

        public ApiVCSConfig(String userName, String password, String baseUrl, String organization) {
            this.userName = userName;
            this.password = password;
            this.baseUrl = baseUrl;
            this.organization = organization;
        }

        public Optional<String> getOrganization() {
            return Optional.ofNullable(this.organization);
        }

        public Optional<String> getUserName() {
            return Optional.ofNullable(this.userName);
        }

        public Optional<String> getPassword() {
            return Optional.ofNullable(this.password);
        }

        public Optional<String> getBaseUrl() {
            return Optional.ofNullable(this.baseUrl);
        }
    }

    static class CoreServicesUserInfoProvider
    implements UserInfoProvider {
        private Lazy<String> orgId;
        private Lazy<String> userId;
        private Lazy<String> accessToken;

        public CoreServicesUserInfoProvider(Lazy<String> username, Lazy<String> password, String orgId) {
            Optional<String> maybeOrgId = Optional.ofNullable(orgId);
            this.orgId = maybeOrgId.map(id -> Lazy.lazily(() -> id)).orElse(Lazy.lazily(() -> ((MeGETResponseBody)ApiClientFactory.coreServices().api.me.get(this.getAccessToken()).getBody()).getUser().getOrganizationId()));
            this.userId = Lazy.lazily(() -> ((MeGETResponseBody)ApiClientFactory.coreServices().api.me.get(this.getAccessToken()).getBody()).getUser().getId());
            this.accessToken = Lazy.lazily(() -> {
                try {
                    CoreServicesAPIReferenceResponse userData = ApiClientFactory.coreServices().login.post(new LoginPOSTBody((String)username.get(), (String)password.get()));
                    return ((LoginPOSTResponseBody)userData.getBody()).getAccessToken();
                }
                catch (CoreServicesAPIReferenceException e) {
                    throw new RuntimeException("Invalid username password");
                }
            });
        }

        public String getAccessToken() {
            return this.accessToken.get();
        }

        public String getOrgId() {
            return this.orgId.get();
        }

        public String getUserId() {
            return this.userId.get();
        }
    }
}

