/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.cli;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.mule.api.vcs.cli.ApiClientFactory;
import org.mule.api.vcs.cli.BaseAuthorizedCommand;
import org.mule.api.vcs.client.ApiVCSClient;
import org.mule.api.vcs.client.BranchInfo;
import org.mule.api.vcs.client.ValueResult;
import org.mule.api.vcs.client.service.RepositoryFileManager;
import org.mule.api.vcs.client.service.UserInfoProvider;
import org.mule.api.vcs.client.service.impl.ApiRepositoryFileManager;
import org.mule.apidesigner.resource.projects.model.Project;
import org.mule.apidesigner.resource.projects.model.ProjectsGETHeader;
import org.mule.apidesigner.responses.ApiDesignerXapiResponse;
import picocli.CommandLine;

@CommandLine.Command(description={"Clones a project in the given location"}, name="clone", mixinStandardHelpOptions=true, version={"checksum 0.1"})
public class CloneCommand
extends BaseAuthorizedCommand
implements Callable<Integer> {
    @CommandLine.Parameters(description={"The project to clone."}, arity="1", index="0")
    String projectName;
    @CommandLine.Parameters(description={"Target directory name"}, arity="0..1", index="1")
    String targetDirectory;
    @CommandLine.Option(names={"-b", "--branch"}, description={"The branch name."})
    String branch;

    @Override
    public Integer call() throws Exception {
        String folderName;
        UserInfoProvider accessTokenProvider = this.getAccessTokenProvider();
        String projectId = null;
        ApiDesignerXapiResponse xapiResponse = ApiClientFactory.apiDesigner().projects.get(new ProjectsGETHeader(this.getAccessTokenProvider().getOrgId(), this.getAccessTokenProvider().getUserId()), this.getAccessTokenProvider().getAccessToken());
        List body = (List)xapiResponse.getBody();
        for (Project project : body) {
            if (!project.getName().equals(this.projectName)) continue;
            projectId = project.getId();
        }
        if (projectId != null) {
            folderName = this.targetDirectory == null ? this.projectName : this.targetDirectory;
        } else {
            System.err.println("[Error] Unable to find project with name `" + this.projectName + "`");
            return -1;
        }
        File workingDirectory = new File(folderName);
        if (workingDirectory.exists()) {
            System.err.println("[Error] Target directory already exists.");
            return -1;
        }
        boolean mkdirs = workingDirectory.mkdirs();
        if (!mkdirs) {
            System.err.println("[Error] Unable to create target directory.");
            return -1;
        }
        ApiVCSClient apiVCSClient = new ApiVCSClient(workingDirectory, (RepositoryFileManager)new ApiRepositoryFileManager());
        System.out.println("Start clone for project: " + this.projectName);
        ValueResult master = apiVCSClient.clone(accessTokenProvider, new BranchInfo(projectId, Optional.ofNullable(this.branch).orElse("master"), accessTokenProvider.getOrgId()));
        if (master.isFailure()) {
            if (master.getMessage().isPresent()) {
                System.err.println("[Error] " + master.getMessage().get());
            }
            return -1;
        }
        System.out.println("Project was cloned successfully.");
        System.out.println();
        return 1;
    }
}

