/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.cli;

import java.io.File;
import java.util.concurrent.Callable;
import org.mule.api.vcs.cli.BaseAuthorizedCommand;
import org.mule.api.vcs.cli.MergeListenerLogger;
import org.mule.api.vcs.client.ApiVCSClient;
import org.mule.api.vcs.client.ValueResult;
import org.mule.api.vcs.client.diff.MergeListener;
import org.mule.api.vcs.client.service.ApiType;
import org.mule.api.vcs.client.service.RepositoryFileManager;
import org.mule.api.vcs.client.service.impl.ApiRepositoryFileManager;
import picocli.CommandLine;

@CommandLine.Command(description={"Inits this project"}, name="create", mixinStandardHelpOptions=true, version={"checksum 0.1"})
public class CreateCommand
extends BaseAuthorizedCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"-t", "--type"}, description={"The type of project by default is `RAML`"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    ApiType apiType = ApiType.RAML;
    @CommandLine.Parameters(description={"The name of the project if not specified used the name of the current folder"}, arity="1")
    String name;
    @CommandLine.Option(names={"-d", "--description"}, description={"The description of this project."}, arity="0..1")
    String description;

    @Override
    public Integer call() throws Exception {
        System.out.println();
        System.out.println("Start creating project `" + this.name + "`");
        ApiVCSClient apiVCSClient = new ApiVCSClient(new File(this.name), (RepositoryFileManager)new ApiRepositoryFileManager());
        ValueResult master = apiVCSClient.create(this.getAccessTokenProvider(), (MergeListener)new MergeListenerLogger(), this.apiType, this.name, this.description);
        if (master.isFailure()) {
            if (master.getMessage().isPresent()) {
                System.err.println("[Error] " + master.getMessage().get());
            }
            return -1;
        }
        System.out.println("Project `" + this.name + "` created successfully.");
        System.out.println();
        return 1;
    }
}

