/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.cli;

import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.Callable;
import org.mule.api.vcs.cli.BaseCommand;
import org.mule.api.vcs.client.ApiVCSClient;
import org.mule.api.vcs.client.ValueResult;
import org.mule.api.vcs.client.diff.Diff;
import picocli.CommandLine;

@CommandLine.Command(description={"Show diffs"}, name="diff", mixinStandardHelpOptions=true, version={"checksum 0.1"})
public class DiffCommand
extends BaseCommand
implements Callable<Integer> {
    @Override
    public Integer call() throws Exception {
        ApiVCSClient apiVCSClient = this.createLocalApiVcsClient();
        ValueResult mayBeDiffs = apiVCSClient.diff();
        if (mayBeDiffs.isFailure()) {
            System.err.println((String)mayBeDiffs.getMessage().get());
            return -1;
        }
        if (((List)mayBeDiffs.doGetValue()).isEmpty()) {
            System.out.println("No differences found.");
        } else {
            PrintWriter printWriter = new PrintWriter(System.out);
            for (Diff diff : (List)mayBeDiffs.doGetValue()) {
                diff.print(printWriter);
            }
            printWriter.close();
        }
        return 1;
    }
}

