/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.cli;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.mule.api.vcs.cli.BaseAuthorizedCommand;
import org.mule.api.vcs.client.ApiVCSClient;
import org.mule.api.vcs.client.service.ProjectInfo;
import org.mule.api.vcs.client.service.RepositoryFileManager;
import org.mule.api.vcs.client.service.impl.ApiRepositoryFileManager;
import picocli.CommandLine;

@CommandLine.Command(description={"List all projects under the given organization"}, name="list", mixinStandardHelpOptions=true, version={"checksum 0.1"})
public class ListProjectsCommand
extends BaseAuthorizedCommand
implements Callable<Integer> {
    @Override
    public Integer call() throws Exception {
        File workingDirectory = new File(".");
        ApiVCSClient apiVCSClient = new ApiVCSClient(workingDirectory, (RepositoryFileManager)new ApiRepositoryFileManager());
        List master = apiVCSClient.list(this.getAccessTokenProvider());
        Integer idLength = master.stream().map(p -> p.getProjectId().length()).max(Integer::compareTo).orElse(0);
        Integer nameLength = master.stream().map(p -> p.getProjectName().length()).max(Integer::compareTo).orElse(0);
        Integer descriptionLength = master.stream().map(p -> Optional.ofNullable(p.getProjectDescription()).map(String::length).orElse(0)).max(Integer::compareTo).orElse(0);
        String header = StringUtils.rightPad((String)" Id", (int)idLength) + " | " + StringUtils.rightPad((String)" Name", (int)nameLength) + " | " + StringUtils.rightPad((String)" Description", (int)descriptionLength);
        System.out.println();
        System.out.println(header);
        System.out.println(StringUtils.repeat((String)"-", (int)header.length()));
        for (ProjectInfo projectInfo : master) {
            System.out.println(StringUtils.rightPad((String)projectInfo.getProjectId(), (int)idLength) + " | " + StringUtils.rightPad((String)projectInfo.getProjectName(), (int)nameLength) + " | " + StringUtils.rightPad((String)Optional.ofNullable(projectInfo.getProjectDescription()).orElse(""), (int)descriptionLength));
        }
        System.out.println();
        return 1;
    }
}

