/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.cli;

import java.util.List;
import java.util.concurrent.Callable;
import org.mule.api.vcs.cli.BaseAuthorizedCommand;
import org.mule.api.vcs.cli.MergeListenerLogger;
import org.mule.api.vcs.client.ApiVCSClient;
import org.mule.api.vcs.client.ValueResult;
import org.mule.api.vcs.client.diff.ApplyResult;
import org.mule.api.vcs.client.diff.Diff;
import org.mule.api.vcs.client.diff.MergeListener;
import org.mule.api.vcs.client.diff.MergingStrategy;
import picocli.CommandLine;

@CommandLine.Command(description={"Publish to exchange"}, name="publish", mixinStandardHelpOptions=true, version={"checksum 0.1"})
public class PublishCommand
extends BaseAuthorizedCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--merge_strategy"}, description={"Strategy to be used for merging 'KEEP_THEIRS','KEEP_BOTH' or 'KEEP_OURS'"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    MergingStrategy mergingStrategy = MergingStrategy.KEEP_BOTH;

    @Override
    public Integer call() throws Exception {
        ApiVCSClient apiVCSClient = this.createLocalApiVcsClient();
        ValueResult master = apiVCSClient.publish(this.getAccessTokenProvider(), this.mergingStrategy, (MergeListener)new MergeListenerLogger(){

            @Override
            public void startApplying(List<Diff> diffs) {
                if (diffs.size() > 0) {
                    System.out.println(diffs.size() + " changes were found on the server. Start merging those changes");
                }
            }

            @Override
            public void endApplying(List<Diff> diffs, List<ApplyResult> result) {
                if (diffs.size() > 0) {
                    boolean failure = result.stream().anyMatch(a -> !a.isSuccess());
                    if (failure) {
                        System.out.println("Merge has conflicts. Fix them before next push.");
                    } else {
                        System.out.println("Merge was successful.");
                    }
                }
            }
        });
        if (master.isFailure()) {
            return -1;
        }
        System.out.println("Changes were pushed successfully.");
        System.out.println();
        return 1;
    }
}

