/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.cli;

import java.util.concurrent.Callable;
import org.mule.api.vcs.cli.BaseAuthorizedCommand;
import org.mule.api.vcs.cli.MergeListenerLogger;
import org.mule.api.vcs.client.ApiVCSClient;
import org.mule.api.vcs.client.ValueResult;
import org.mule.api.vcs.client.diff.MergeListener;
import org.mule.api.vcs.client.diff.MergingStrategy;
import picocli.CommandLine;

@CommandLine.Command(description={"Pulls from the api server."}, name="pull", mixinStandardHelpOptions=true, version={"checksum 0.1"})
public class PullCommand
extends BaseAuthorizedCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--merge_strategy"}, description={"Strategy to be used for merging 'KEEP_THEIRS','KEEP_BOTH' or 'KEEP_OURS'"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    MergingStrategy mergingStrategy = MergingStrategy.KEEP_BOTH;

    @Override
    public Integer call() throws Exception {
        ApiVCSClient apiVCSClient = this.createLocalApiVcsClient();
        ValueResult valueResult = apiVCSClient.currentBranch();
        if (valueResult.isFailure()) {
            System.err.println((String)valueResult.getMessage().get());
            return -1;
        }
        System.out.println();
        System.out.println("Start pulling from " + (String)valueResult.doGetValue());
        ValueResult master = apiVCSClient.pull(this.getAccessTokenProvider(), this.mergingStrategy, (MergeListener)new MergeListenerLogger());
        if (master.isFailure()) {
            if (master.getMessage().isPresent()) {
                System.err.println("[Error] There where some conflicts while pulling.");
            }
            return -1;
        }
        System.out.println();
        System.out.println("Pulled from `" + (String)valueResult.doGetValue() + "` successfully.");
        System.out.println();
        return 1;
    }
}

