/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.cli;

import java.util.concurrent.Callable;
import org.mule.api.vcs.cli.BaseAuthorizedCommand;
import org.mule.api.vcs.client.ApiVCSClient;
import org.mule.api.vcs.client.ValueResult;
import picocli.CommandLine;

@CommandLine.Command(description={"Reverts all changes."}, name="revert-all", mixinStandardHelpOptions=true, version={"checksum 0.1"})
public class RevertAllCommand
extends BaseAuthorizedCommand
implements Callable<Integer> {
    @Override
    public Integer call() throws Exception {
        ApiVCSClient apiVCSClient = this.createLocalApiVcsClient();
        ValueResult master = apiVCSClient.revertAll();
        if (master.isFailure()) {
            if (master.getMessage().isPresent()) {
                System.err.println("[Error] " + (String)master.getMessage().get());
            }
            return -1;
        }
        ValueResult valueResult = apiVCSClient.currentBranch();
        System.out.println();
        System.out.println("All changes were reverted successfully.");
        System.out.println();
        return 1;
    }
}

