/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.cli;

import java.util.concurrent.Callable;
import org.mule.api.vcs.cli.BaseAuthorizedCommand;
import org.mule.api.vcs.client.ApiVCSClient;
import org.mule.api.vcs.client.ValueResult;
import picocli.CommandLine;

@CommandLine.Command(description={"Reverts a given file."}, name="revert", mixinStandardHelpOptions=true, version={"checksum 0.1"})
public class RevertCommand
extends BaseAuthorizedCommand
implements Callable<Integer> {
    @CommandLine.Parameters(description={"The file to revert."}, arity="1", index="0")
    String relativePath;

    @Override
    public Integer call() throws Exception {
        ApiVCSClient apiVCSClient = this.createLocalApiVcsClient();
        ValueResult master = apiVCSClient.revert(this.relativePath);
        if (master.isFailure()) {
            if (master.getMessage().isPresent()) {
                System.err.println("[Error] " + (String)master.getMessage().get());
            }
            return -1;
        }
        ValueResult valueResult = apiVCSClient.currentBranch();
        System.out.println();
        System.out.println("File reverted " + this.relativePath + " successfully.");
        System.out.println();
        return 1;
    }
}

