/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.cli;

import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.Callable;
import org.mule.api.vcs.cli.BaseAuthorizedCommand;
import org.mule.api.vcs.client.ApiVCSClient;
import org.mule.api.vcs.client.ValueResult;
import org.mule.api.vcs.client.diff.Diff;
import picocli.CommandLine;

@CommandLine.Command(description={"Show the status"}, name="status", mixinStandardHelpOptions=true, version={"checksum 0.1"})
public class StatusCommand
extends BaseAuthorizedCommand
implements Callable<Integer> {
    @Override
    public Integer call() throws Exception {
        System.out.println();
        ApiVCSClient apiVCSClient = this.createLocalApiVcsClient();
        ValueResult mayBeDiffs = apiVCSClient.diff();
        if (mayBeDiffs.isFailure()) {
            System.err.println((String)mayBeDiffs.getMessage().get());
            return -1;
        }
        if (((List)mayBeDiffs.doGetValue()).isEmpty()) {
            System.out.println("No changes found.");
        } else {
            System.out.println();
            System.out.println("Changes to be committed:");
            System.out.println();
            PrintWriter printWriter = new PrintWriter(System.out);
            for (Diff diff : (List)mayBeDiffs.doGetValue()) {
                printWriter.println("\t" + diff.getOperationType().getLabel() + " " + diff.getRelativePath());
            }
            printWriter.flush();
        }
        System.out.println();
        return 1;
    }
}

