/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.client;

import com.github.difflib.DiffUtils;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.patch.Patch;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.mule.api.vcs.client.BranchInfo;
import org.mule.api.vcs.client.DefaultMergeListener;
import org.mule.api.vcs.client.PublishInfo;
import org.mule.api.vcs.client.ValueResult;
import org.mule.api.vcs.client.diff.ApplyResult;
import org.mule.api.vcs.client.diff.DeleteFileDiff;
import org.mule.api.vcs.client.diff.Diff;
import org.mule.api.vcs.client.diff.MergeConflictDiff;
import org.mule.api.vcs.client.diff.MergeListener;
import org.mule.api.vcs.client.diff.MergingStrategy;
import org.mule.api.vcs.client.diff.ModifiedFileDiff;
import org.mule.api.vcs.client.diff.NewFileConflictDiff;
import org.mule.api.vcs.client.diff.NewFileDiff;
import org.mule.api.vcs.client.service.ApiBranch;
import org.mule.api.vcs.client.service.ApiFile;
import org.mule.api.vcs.client.service.ApiFileContent;
import org.mule.api.vcs.client.service.ApiType;
import org.mule.api.vcs.client.service.BranchRepositoryLock;
import org.mule.api.vcs.client.service.OrgIdUserInfoProviderDecorator;
import org.mule.api.vcs.client.service.ProjectInfo;
import org.mule.api.vcs.client.service.RepositoryFileManager;
import org.mule.api.vcs.client.service.UserInfoProvider;
import org.mule.maven.exchange.model.ExchangeModel;
import org.mule.maven.exchange.model.ExchangeModelSerializer;

public class ApiVCSClient {
    public static final String PROJECT_ID_KEY = "projectId";
    public static final String BRANCH_KEY = "branch";
    public static final String APIVCS_FOLDER_NAME = ".apivcs";
    public static final String ORG_ID_KEY = "orgId";
    private File targetDirectory;
    private RepositoryFileManager fileManager;

    public ApiVCSClient(File targetDirectory, RepositoryFileManager fileManager) {
        this.targetDirectory = targetDirectory;
        this.fileManager = fileManager;
    }

    public List<String> branches(UserInfoProvider provider, String projectId) {
        List<ApiBranch> theBranch = this.fileManager.branches(provider, projectId);
        return theBranch.stream().map(branch -> branch.getName()).collect(Collectors.toList());
    }

    public ValueResult<Void> clone(UserInfoProvider provider, BranchInfo config) {
        ValueResult<Void> valueResult = this.storeConfig(config.getProjectId(), config.getBranch(), config.getOrgId());
        if (valueResult.isFailure()) {
            return valueResult.asFailure();
        }
        File branchDirectory = this.getBranchDirectory(config.getBranch());
        if (branchDirectory.mkdirs()) {
            BranchRepositoryLock apiLock = this.fileManager.acquireLock(OrgIdUserInfoProviderDecorator.withOrgId(provider, config.getOrgId()), config.getProjectId(), config.getBranch());
            if (apiLock.isSuccess()) {
                return this.cloneBranchContentTo(apiLock, this.targetDirectory, branchDirectory);
            }
            return this.repositoryAlreadyLocked(apiLock);
        }
        return ValueResult.fail("Unable to initialize apivcs as it was already initialized. Clean .apivcs directory before clone.");
    }

    public ValueResult<Void> create(UserInfoProvider provider, MergeListener listener, ApiType apiType, String name, String description) {
        try {
            File file = this.targetDirectory;
            if (file.exists()) {
                return ValueResult.fail("Folder " + name + " already exists");
            }
            file.mkdirs();
            BranchInfo branchInfo = this.fileManager.create(provider, apiType, name, description);
            this.storeConfig(branchInfo.getProjectId(), branchInfo.getBranch(), provider.getOrgId());
            return this.pull(provider, MergingStrategy.KEEP_BOTH, listener);
        }
        catch (Exception e) {
            return ValueResult.fail(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ValueResult<Void> publish(UserInfoProvider provider, MergingStrategy mergingStrategy, MergeListener listener) {
        File exchangeJsonFile = new File(this.targetDirectory, "exchange.json");
        if (!exchangeJsonFile.exists()) {
            return ValueResult.fail("exchange.json file is not present");
        }
        ValueResult<BranchInfo> mayBeBranchInfo = this.loadConfig();
        if (mayBeBranchInfo.isFailure()) {
            return mayBeBranchInfo.asFailure();
        }
        BranchInfo branchInfo = mayBeBranchInfo.getValue().get();
        String branchName = branchInfo.getBranch();
        try {
            BranchRepositoryLock acquireLock = this.fileManager.acquireLock(OrgIdUserInfoProviderDecorator.withOrgId(provider, branchInfo.getOrgId()), branchInfo.getProjectId(), branchName);
            if (acquireLock.isSuccess()) {
                ValueResult<Void> voidValueResult = this.pull(acquireLock, branchInfo, mergingStrategy, listener);
                if (voidValueResult.isSuccess()) {
                    try {
                        ExchangeModel exchangeModel = new ExchangeModelSerializer().read(exchangeJsonFile);
                        PublishInfo publishInfo = new PublishInfo(exchangeModel.getName(), exchangeModel.getApiVersion(), exchangeModel.getVersion(), exchangeModel.getTags(), exchangeModel.getMain(), exchangeModel.getAssetId(), exchangeModel.getGroupId(), exchangeModel.getClassifier(), branchInfo);
                        this.fileManager.publish(OrgIdUserInfoProviderDecorator.withOrgId(provider, branchInfo.getOrgId()), publishInfo);
                        ValueResult<Void> valueResult = ValueResult.SUCCESS;
                        return valueResult;
                    }
                    catch (IOException e) {
                        ValueResult<Void> valueResult = ValueResult.fail(" Unable to parse `exchange.json` : " + e.getMessage());
                        this.fileManager.releaseLock(OrgIdUserInfoProviderDecorator.withOrgId(provider, branchInfo.getOrgId()), branchInfo.getProjectId(), branchName);
                        return valueResult;
                    }
                }
                ValueResult<Void> valueResult = voidValueResult;
                return valueResult;
            }
            ValueResult<Void> valueResult = this.repositoryAlreadyLocked(acquireLock);
            return valueResult;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.fileManager.releaseLock(OrgIdUserInfoProviderDecorator.withOrgId(provider, branchInfo.getOrgId()), branchInfo.getProjectId(), branchName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueResult<Void> push(UserInfoProvider provider, MergingStrategy mergingStrategy, MergeListener listener) {
        ValueResult<BranchInfo> mayBeBranchInfo = this.loadConfig();
        if (mayBeBranchInfo.isFailure()) {
            return mayBeBranchInfo.asFailure();
        }
        BranchInfo branchInfo = mayBeBranchInfo.getValue().get();
        String branchName = branchInfo.getBranch();
        try {
            BranchRepositoryLock acquireLock = this.fileManager.acquireLock(OrgIdUserInfoProviderDecorator.withOrgId(provider, branchInfo.getOrgId()), branchInfo.getProjectId(), branchName);
            if (acquireLock.isSuccess()) {
                List<Diff> diffs = this.calculateDiff(branchInfo);
                if (!diffs.isEmpty()) {
                    if (this.containsConflict(diffs)) {
                        ValueResult<Void> valueResult = ValueResult.fail("Resolve conflicts before pushing.");
                        return valueResult;
                    }
                    ValueResult<Void> voidValueResult = this.pull(acquireLock, branchInfo, mergingStrategy, listener);
                    if (voidValueResult.isSuccess()) {
                        List<Diff> newDiffs = this.calculateDiff(branchInfo);
                        listener.startPushing(newDiffs);
                        for (Diff newDiff : newDiffs) {
                            newDiff.push(acquireLock.getBranchRepositoryManager(), this.targetDirectory);
                            listener.pushing(newDiff);
                        }
                        this.applyDiffsOn(diffs, mergingStrategy, new DefaultMergeListener(), this.getBranchDirectory(branchName));
                        ValueResult<Void> valueResult = ValueResult.SUCCESS;
                        return valueResult;
                    }
                    ValueResult<Void> valueResult = voidValueResult;
                    return valueResult;
                }
                ValueResult<Void> valueResult = ValueResult.SUCCESS;
                return valueResult;
            }
            ValueResult<Void> valueResult = this.repositoryAlreadyLocked(acquireLock);
            return valueResult;
        }
        finally {
            this.fileManager.releaseLock(OrgIdUserInfoProviderDecorator.withOrgId(provider, branchInfo.getOrgId()), branchInfo.getProjectId(), branchName);
        }
    }

    private boolean containsConflict(List<Diff> diffs) {
        return diffs.stream().anyMatch(diff -> diff instanceof NewFileConflictDiff || diff instanceof MergeConflictDiff);
    }

    private ValueResult<Void> repositoryAlreadyLocked(BranchRepositoryLock acquireLock) {
        return ValueResult.fail("Repository is locked by " + acquireLock.getOwner());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ValueResult<Void> pull(UserInfoProvider provider, MergingStrategy mergingStrategy, MergeListener listener) {
        ValueResult<BranchInfo> mayBeBranchInfo = this.loadConfig();
        if (mayBeBranchInfo.isFailure()) {
            return mayBeBranchInfo.asFailure();
        }
        BranchInfo config = mayBeBranchInfo.getValue().get();
        BranchRepositoryLock apiLock = this.fileManager.acquireLock(OrgIdUserInfoProviderDecorator.withOrgId(provider, config.getOrgId()), config.getProjectId(), config.getBranch());
        if (apiLock.isSuccess()) {
            try {
                ValueResult<Void> valueResult = this.pull(apiLock, config, mergingStrategy, listener);
                return valueResult;
            }
            finally {
                this.fileManager.releaseLock(OrgIdUserInfoProviderDecorator.withOrgId(provider, config.getOrgId()), config.getProjectId(), config.getBranch());
            }
        }
        return this.repositoryAlreadyLocked(apiLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueResult<Void> pull(BranchRepositoryLock apiLock, BranchInfo config, MergingStrategy mergingStrategy, MergeListener listener) {
        if (this.containsConflict(this.diff().getValue().orElse(new ArrayList()))) {
            return ValueResult.fail("Resolve conflicts before trying to pull.");
        }
        File staging = this.getStagingDirectory();
        try {
            ValueResult<Void> voidValueResult = this.cloneBranchContentTo(apiLock, staging);
            ValueResult<Void> valueResult = voidValueResult.flatMap(success -> {
                File branchDirectory = this.getBranchDirectory(config.getBranch());
                List<Diff> diffs = this.calculateDiff(staging, branchDirectory);
                List<ApplyResult> applyResults = this.applyDiffsOn(diffs, mergingStrategy, listener, this.targetDirectory);
                this.applyDiffsOn(diffs, mergingStrategy, new DefaultMergeListener(), branchDirectory);
                boolean failure = applyResults.stream().anyMatch(a -> !a.isSuccess());
                if (failure) {
                    String errorMessage = applyResults.stream().filter(a -> !a.isSuccess()).map(a -> a.getMessage().get()).reduce((l, r) -> l + "\n" + r).orElse("");
                    return ValueResult.fail(errorMessage);
                }
                return ValueResult.SUCCESS;
            });
            return valueResult;
        }
        finally {
            this.deleteDirectory(staging);
        }
    }

    private File getStagingDirectory() {
        File stagingDirectory = new File(this.getApiVCSDirectory(), "tmp" + File.separator + "staging");
        if (stagingDirectory.exists()) {
            this.deleteDirectory(stagingDirectory);
        }
        stagingDirectory.mkdirs();
        return stagingDirectory;
    }

    private List<ApplyResult> applyDiffsOn(List<Diff> diffs, MergingStrategy mergingStrategy, MergeListener listener, File targetDirectory) {
        listener.startApplying(diffs);
        List<ApplyResult> result = diffs.stream().map(diff -> {
            ApplyResult apply = diff.apply(targetDirectory, mergingStrategy);
            listener.applied((Diff)diff, apply);
            return apply;
        }).collect(Collectors.toList());
        listener.endApplying(diffs, result);
        return result;
    }

    public ValueResult<List<Diff>> diff() {
        ValueResult<BranchInfo> mayBeBranchInfo = this.loadConfig();
        if (mayBeBranchInfo.isFailure()) {
            return mayBeBranchInfo.asFailure();
        }
        BranchInfo branchInfo = mayBeBranchInfo.getValue().get();
        List<Diff> value = this.calculateDiff(branchInfo);
        return ValueResult.success(value);
    }

    private List<Diff> calculateDiff(BranchInfo branchInfo) {
        String branchName = branchInfo.getBranch();
        File branchDirectory = this.getBranchDirectory(branchName);
        return this.calculateDiff(this.targetDirectory, branchDirectory);
    }

    public List<ProjectInfo> list(UserInfoProvider provider) {
        return this.fileManager.projects(provider);
    }

    private void deleteDirectory(File branchDirectory) {
        this.deleteDirectory(branchDirectory, pathname -> true);
    }

    private ValueResult<Void> cloneBranchContentTo(BranchRepositoryLock apiLock, File ... targetDirectory) {
        List<ApiFile> apiFiles = apiLock.getBranchRepositoryManager().listFiles();
        for (ApiFile file : apiFiles) {
            try {
                if (file.getPath().startsWith("exchange_modules/")) continue;
                ApiFileContent fileGetResponse = apiLock.getBranchRepositoryManager().fileContent(file.getPath());
                for (File directory : targetDirectory) {
                    File targetFile = new File(directory, file.getPath());
                    if (!targetFile.getParentFile().exists()) {
                        targetFile.getParentFile().mkdirs();
                    }
                    try (FileOutputStream writer = new FileOutputStream(targetFile);){
                        writer.write(fileGetResponse.getContent());
                    }
                }
            }
            catch (IOException e) {
                return ValueResult.fail("Problem while trying to write file " + file.getPath() + ".");
            }
        }
        return ValueResult.SUCCESS;
    }

    protected File getBranchDirectory(String branch) {
        File branches = new File(this.getApiVCSDirectory(), "branches");
        return new File(branches, branch);
    }

    protected File getApiVCSDirectory() {
        return new File(this.targetDirectory, APIVCS_FOLDER_NAME);
    }

    private void cleanupWorkspace() {
        this.deleteDirectory(this.targetDirectory, file -> !file.isDirectory() || !file.equals(this.getApiVCSDirectory()));
    }

    private void deleteDirectory(File branchDirectory, final FileFilter filter) {
        try {
            Files.walkFileTree(branchDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (!filter.accept(dir.toFile())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (filter.accept(file.toFile())) {
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<Diff> calculateDiff(File modified, File original) {
        return this.calculateDiff(modified, original, ".");
    }

    private List<Diff> calculateDiff(File revised, File original, final String relativePath) {
        ArrayList<Diff> diffs;
        block23: {
            diffs = new ArrayList<Diff>();
            if (this.isIgnore(revised)) {
                return diffs;
            }
            try {
                if (revised.isDirectory() && original.isDirectory()) {
                    File[] targetChildren;
                    File[] sourceChildren = revised.listFiles();
                    if (sourceChildren != null) {
                        for (File sourceChild : sourceChildren) {
                            diffs.addAll(this.calculateDiff(sourceChild, new File(original, sourceChild.getName()), relativePath + File.separator + sourceChild.getName()));
                        }
                    }
                    if ((targetChildren = original.listFiles()) != null) {
                        for (File targetChild : targetChildren) {
                            File sourceChild = new File(revised, targetChild.getName());
                            if (sourceChild.exists()) continue;
                            if (targetChild.isDirectory()) {
                                this.addDeletedDiffs(targetChild.toPath(), relativePath, diffs);
                                continue;
                            }
                            String deletedFilePath = relativePath + File.separator + targetChild.getName();
                            diffs.add(new DeleteFileDiff(deletedFilePath, Files.readAllLines(targetChild.toPath(), BranchInfo.DEFAULT_CHARSET)));
                        }
                    }
                    break block23;
                }
                final Path sourcePath = revised.toPath();
                Path targetPath = original.toPath();
                if (revised.isDirectory()) {
                    if (original.isFile()) {
                        diffs.add(new DeleteFileDiff(relativePath, Files.readAllLines(original.toPath(), BranchInfo.DEFAULT_CHARSET)));
                    }
                    Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            if (attrs.isRegularFile()) {
                                String newRelativePath = relativePath + File.separator + sourcePath.relativize(file).toString();
                                byte[] content = Files.readAllBytes(file);
                                diffs.add(new NewFileDiff(content, newRelativePath));
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break block23;
                }
                if (original.isDirectory()) {
                    if (revised.isFile()) {
                        byte[] content = Files.readAllBytes(sourcePath);
                        diffs.add(new NewFileDiff(content, relativePath));
                    }
                    this.addDeletedDiffs(targetPath, relativePath, diffs);
                    break block23;
                }
                if (revised.isFile()) {
                    File theirsFile = new File(revised.getPath() + ".theirs");
                    if (theirsFile.exists()) {
                        List<String> theirsLines = Files.readAllLines(theirsFile.toPath(), BranchInfo.DEFAULT_CHARSET);
                        List<String> originalLines = Files.readAllLines(revised.toPath(), BranchInfo.DEFAULT_CHARSET);
                        File oursFile = new File(revised.getPath() + ".original");
                        if (oursFile.exists()) {
                            List<String> oursLines = Files.readAllLines(oursFile.toPath(), BranchInfo.DEFAULT_CHARSET);
                            diffs.add(new MergeConflictDiff(originalLines, theirsLines, oursLines, relativePath));
                        } else {
                            diffs.add(new NewFileConflictDiff(theirsLines, originalLines, relativePath));
                        }
                        break block23;
                    }
                    if (original.isFile()) {
                        List<String> originalLines = Files.readAllLines(original.toPath(), BranchInfo.DEFAULT_CHARSET);
                        List<String> revisedLines = Files.readAllLines(revised.toPath(), BranchInfo.DEFAULT_CHARSET);
                        try {
                            Patch diff = DiffUtils.diff(originalLines, revisedLines);
                            if (!diff.getDeltas().isEmpty()) {
                                diffs.add(new ModifiedFileDiff((Patch<String>)diff, relativePath, originalLines, original));
                            }
                            break block23;
                        }
                        catch (DiffException e) {
                            throw new RuntimeException(e.getMessage());
                        }
                    }
                    if (!original.exists()) {
                        diffs.add(new NewFileDiff(Files.readAllBytes(revised.toPath()), relativePath));
                    }
                    break block23;
                }
                if (original.isFile() && !revised.exists()) {
                    diffs.add(new DeleteFileDiff(relativePath, Files.readAllLines(original.toPath(), BranchInfo.DEFAULT_CHARSET)));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return diffs;
    }

    private boolean isIgnore(File source) {
        return source.isHidden() || source.getName().endsWith(".theirs") || source.getName().endsWith(".original");
    }

    private void addDeletedDiffs(final Path targetPath, final String relativePath, final ArrayList<Diff> diffs) throws IOException {
        Files.walkFileTree(targetPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (attrs.isRegularFile()) {
                    String newRelativePath = relativePath + File.separator + targetPath.relativize(file).toString();
                    try {
                        diffs.add(new DeleteFileDiff(newRelativePath, Files.readAllLines(targetPath, BranchInfo.DEFAULT_CHARSET)));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private ValueResult<Void> storeConfig(String projectId, String branch, String groupId) {
        File apiVCSDirectory = this.getApiVCSDirectory();
        apiVCSDirectory.mkdirs();
        File config = ApiVCSClient.getConfigFile(apiVCSDirectory);
        Properties properties = new Properties();
        properties.put(PROJECT_ID_KEY, projectId);
        properties.put(BRANCH_KEY, branch);
        properties.put(ORG_ID_KEY, groupId);
        try (FileOutputStream fileOutputStream = new FileOutputStream(config);){
            properties.store(fileOutputStream, "");
        }
        catch (IOException e) {
            return ValueResult.fail("Unable to store settings at : " + config.getAbsolutePath() + ". Verify the user has the right access.");
        }
        return ValueResult.SUCCESS;
    }

    public static File getConfigFile(File apiVCSDirectory) {
        return new File(apiVCSDirectory, "config.properties");
    }

    protected ValueResult<BranchInfo> loadConfig() {
        File apiVCSDirectory = this.getApiVCSDirectory();
        Properties properties = new Properties();
        if (!apiVCSDirectory.exists()) {
            return ValueResult.fail("Not an apivcs directory.");
        }
        try (FileInputStream inStream = new FileInputStream(ApiVCSClient.getConfigFile(apiVCSDirectory));){
            properties.load(inStream);
        }
        catch (IOException e) {
            return ValueResult.fail(e.getMessage());
        }
        return ValueResult.success(new BranchInfo(properties.getProperty(PROJECT_ID_KEY), properties.getProperty(BRANCH_KEY), properties.getProperty(ORG_ID_KEY)));
    }

    public ValueResult<String> currentBranch() {
        return this.loadConfig().map(b -> b.getBranch());
    }

    public ValueResult<Void> markResolved(String relativePath) {
        try {
            File theirsFile;
            File file = new File(this.targetDirectory, relativePath).getCanonicalFile();
            File oursFile = new File(file.getAbsolutePath() + ".original");
            if (oursFile.exists()) {
                oursFile.delete();
            }
            if ((theirsFile = new File(file.getAbsolutePath() + ".theirs")).exists()) {
                theirsFile.delete();
            }
            return ValueResult.SUCCESS;
        }
        catch (IOException io) {
            return ValueResult.fail(io.getMessage());
        }
    }

    public ValueResult<Void> revert(String relativePath) {
        try {
            File file = new File(this.targetDirectory, relativePath).getCanonicalFile();
            ValueResult<List<Diff>> mayBe = this.diff();
            return mayBe.map(diff -> {
                for (Diff diff1 : diff) {
                    try {
                        File aFileWithDiff = new File(this.targetDirectory, diff1.getRelativePath()).getCanonicalFile();
                        if (!file.equals(aFileWithDiff)) continue;
                        diff1.unApply(this.targetDirectory);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            });
        }
        catch (IOException io) {
            return ValueResult.fail(io.getMessage());
        }
    }

    public ValueResult<Void> revertAll() {
        ValueResult<List<Diff>> mayBe = this.diff();
        return mayBe.map(diff -> {
            for (Diff diff1 : diff) {
                diff1.unApply(this.targetDirectory);
            }
            return null;
        });
    }
}

