/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.client;

import java.util.Optional;
import java.util.function.Function;

public class ValueResult<T> {
    private boolean success;
    private String message;
    private T value;
    public static ValueResult<Void> SUCCESS = new ValueResult<Object>(true, null, null);

    public ValueResult(boolean success, String message, T value) {
        this.success = success;
        this.message = message;
        this.value = value;
    }

    public Optional<T> getValue() {
        return Optional.ofNullable(this.value);
    }

    public T doGetValue() {
        return this.value;
    }

    public static <T> ValueResult<T> success(T value) {
        return new ValueResult<T>(true, null, value);
    }

    public <T> ValueResult<T> asFailure() {
        return ValueResult.fail(this.message);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public <Q> ValueResult<Q> map(Function<T, Q> mapper) {
        if (this.isSuccess()) {
            return ValueResult.success(mapper.apply(this.doGetValue()));
        }
        return this;
    }

    public <Q> ValueResult<Q> flatMap(Function<T, ValueResult<Q>> mapper) {
        if (this.isSuccess()) {
            return mapper.apply(this.doGetValue());
        }
        return this;
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public static <T> ValueResult<T> fail(String message) {
        return new ValueResult<Object>(false, message, null);
    }
}

