/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.client.diff;

import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeleteDelta;
import com.github.difflib.patch.Patch;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mule.api.vcs.client.diff.ApplyResult;
import org.mule.api.vcs.client.diff.Diff;
import org.mule.api.vcs.client.diff.FileUtils;
import org.mule.api.vcs.client.diff.MergeOperation;
import org.mule.api.vcs.client.diff.MergingStrategy;
import org.mule.api.vcs.client.service.BranchRepositoryManager;

public class DeleteFileDiff
implements Diff {
    private String relativePath;
    private List<String> originalLines;

    public DeleteFileDiff(String relativePath, List<String> originalLines) {
        this.relativePath = relativePath;
        this.originalLines = originalLines;
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public MergeOperation getOperationType() {
        return MergeOperation.DELETE;
    }

    @Override
    public ApplyResult unApply(File targetDirectory) {
        return FileUtils.writeFile(targetDirectory, this.relativePath, this.originalLines);
    }

    @Override
    public ApplyResult apply(File targetDirectory, MergingStrategy mergingStrategy) {
        File file = new File(targetDirectory, this.relativePath);
        if (file.exists()) {
            boolean delete = file.delete();
            if (delete) {
                return ApplyResult.SUCCESSFUL;
            }
            String message = "Unable to delete" + file.getAbsolutePath();
            return ApplyResult.fail(message);
        }
        return ApplyResult.success("File `" + this.relativePath + "` was deleted on the server and locally. Ignoring this change.");
    }

    @Override
    public void print(PrintWriter printWriter) {
        printWriter.println("Index: " + this.relativePath);
        printWriter.println("===================================================================");
        Patch patch = new Patch();
        patch.addDelta((AbstractDelta)new DeleteDelta(new Chunk(0, this.originalLines), new Chunk(0, (Object[])new String[0])));
        List stringList = UnifiedDiffUtils.generateUnifiedDiff((String)this.relativePath, (String)this.relativePath, new ArrayList(), (Patch)patch, (int)2);
        for (String line : stringList) {
            printWriter.println(line);
        }
    }

    @Override
    public void push(BranchRepositoryManager branch, File targetDirectory) {
        branch.delete(this.relativePath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteFileDiff that = (DeleteFileDiff)o;
        return Objects.equals(this.relativePath, that.relativePath) && Objects.equals(this.originalLines, that.originalLines);
    }

    public int hashCode() {
        return Objects.hash(this.relativePath, this.originalLines);
    }
}

