/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.client.diff;

import java.io.File;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import org.mule.api.vcs.client.diff.ApplyResult;
import org.mule.api.vcs.client.diff.Conflict;
import org.mule.api.vcs.client.diff.Diff;
import org.mule.api.vcs.client.diff.FileUtils;
import org.mule.api.vcs.client.diff.MergeOperation;
import org.mule.api.vcs.client.diff.MergingStrategy;
import org.mule.api.vcs.client.service.BranchRepositoryManager;

public class MergeConflictDiff
implements Diff,
Conflict {
    private List<String> original;
    private List<String> theirs;
    private List<String> ours;
    private String relativePath;

    public MergeConflictDiff(List<String> original, List<String> theirs, List<String> ours, String relativePath) {
        this.original = original;
        this.theirs = theirs;
        this.ours = ours;
        this.relativePath = relativePath;
    }

    public String getTheirsRelativePath() {
        return this.relativePath + ".theirs";
    }

    public String getOriginalRelativePath() {
        return this.relativePath + ".original";
    }

    @Override
    public ApplyResult resolve(File targetDirectory, MergingStrategy mergingStrategy) {
        File theirsFile = new File(targetDirectory, this.relativePath + ".theirs");
        File oursFile = new File(targetDirectory, this.relativePath + ".original");
        switch (mergingStrategy) {
            case KEEP_OURS: {
                theirsFile.delete();
                oursFile.delete();
                return ApplyResult.SUCCESSFUL;
            }
            case KEEP_THEIRS: {
                FileUtils.writeFile(targetDirectory, this.relativePath, this.theirs);
                theirsFile.delete();
                oursFile.delete();
                return ApplyResult.SUCCESSFUL;
            }
        }
        return ApplyResult.fail("Merge Conflict doesn't support " + (Object)((Object)mergingStrategy));
    }

    @Override
    public ApplyResult apply(File targetDirectory, MergingStrategy mergingStrategy) {
        return ApplyResult.fail("Merge conflicts can not be applied");
    }

    public List<String> getOriginal() {
        return this.original;
    }

    public List<String> getTheirs() {
        return this.theirs;
    }

    public List<String> getOurs() {
        return this.ours;
    }

    @Override
    public void print(PrintWriter printWriter) {
    }

    @Override
    public void push(BranchRepositoryManager branch, File targetDirectory) {
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public MergeOperation getOperationType() {
        return MergeOperation.MERGE_CONFLICT;
    }

    @Override
    public ApplyResult unApply(File targetDirectory) {
        return ApplyResult.fail("Merge conflicts can not be un applied");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeConflictDiff that = (MergeConflictDiff)o;
        return Objects.equals(this.original, that.original) && Objects.equals(this.theirs, that.theirs) && Objects.equals(this.ours, that.ours) && Objects.equals(this.relativePath, that.relativePath);
    }

    public int hashCode() {
        return Objects.hash(this.original, this.theirs, this.ours, this.relativePath);
    }
}

