/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.client.diff;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import com.github.difflib.patch.PatchFailedException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.mule.api.vcs.client.BranchInfo;
import org.mule.api.vcs.client.diff.ApplyResult;
import org.mule.api.vcs.client.diff.Diff;
import org.mule.api.vcs.client.diff.MergeOperation;
import org.mule.api.vcs.client.diff.MergingStrategy;
import org.mule.api.vcs.client.service.BranchRepositoryManager;

public class ModifiedFileDiff
implements Diff {
    private Patch<String> diff;
    private String relativePath;
    private List<String> originalLines;
    private File original;

    public ModifiedFileDiff(Patch<String> diff, String relativePath, List<String> originalLines, File original) {
        this.diff = diff;
        this.relativePath = relativePath;
        this.originalLines = originalLines;
        this.original = original;
    }

    public File getOriginal() {
        return this.original;
    }

    public List<String> getOriginalLines() {
        return this.originalLines;
    }

    @Override
    public ApplyResult apply(File targetDirectory, MergingStrategy mergingStrategy) {
        try {
            Path theFilePath = new File(targetDirectory, this.relativePath).toPath();
            List<String> source = Files.readAllLines(theFilePath, BranchInfo.DEFAULT_CHARSET);
            try {
                List patch = DiffUtils.patch(source, this.diff);
                Files.write(theFilePath, (Iterable<? extends CharSequence>)patch, BranchInfo.DEFAULT_CHARSET, new OpenOption[0]);
            }
            catch (PatchFailedException e) {
                switch (mergingStrategy) {
                    case KEEP_THEIRS: {
                        try {
                            List ours = DiffUtils.patch(this.originalLines, this.diff);
                            Files.write(theFilePath, (Iterable<? extends CharSequence>)ours, BranchInfo.DEFAULT_CHARSET, new OpenOption[0]);
                            break;
                        }
                        catch (PatchFailedException ex) {
                            return ApplyResult.fail("FATAL ERROR while trying to apply patch." + ex.getMessage());
                        }
                    }
                    case KEEP_BOTH: {
                        try {
                            List theirsContent = DiffUtils.patch(this.originalLines, this.diff);
                            Path theirsPath = new File(targetDirectory, this.relativePath + ".theirs").toPath();
                            Path originalPath = new File(targetDirectory, this.relativePath + ".original").toPath();
                            Files.write(theirsPath, (Iterable<? extends CharSequence>)theirsContent, BranchInfo.DEFAULT_CHARSET, new OpenOption[0]);
                            Files.write(originalPath, this.originalLines, BranchInfo.DEFAULT_CHARSET, new OpenOption[0]);
                            break;
                        }
                        catch (PatchFailedException ex) {
                            return ApplyResult.fail("FATAL ERROR while trying to apply patch." + ex.getMessage());
                        }
                    }
                }
                return ApplyResult.fail("Conflict occurred while merging changes.");
            }
            return ApplyResult.SUCCESSFUL;
        }
        catch (IOException e) {
            return this.failError(e);
        }
    }

    @Override
    public void print(PrintWriter printWriter) {
        printWriter.println("Index: " + this.relativePath);
        printWriter.println("===================================================================");
        List stringList = UnifiedDiffUtils.generateUnifiedDiff((String)this.relativePath, (String)this.relativePath, this.originalLines, this.diff, (int)2);
        for (String line : stringList) {
            printWriter.println(line);
        }
    }

    @Override
    public void push(BranchRepositoryManager branch, File targetDirectory) {
        try {
            Path fileToPush = new File(targetDirectory, this.relativePath).getCanonicalFile().toPath();
            branch.updateFile(this.relativePath, Files.readAllBytes(fileToPush));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public MergeOperation getOperationType() {
        return MergeOperation.MODIFIED;
    }

    @Override
    public ApplyResult unApply(File targetDirectory) {
        Path theFilePath = new File(targetDirectory, this.relativePath).toPath();
        try {
            Files.write(theFilePath, this.originalLines, BranchInfo.DEFAULT_CHARSET, new OpenOption[0]);
        }
        catch (IOException e) {
            return this.failError(e);
        }
        return ApplyResult.SUCCESSFUL;
    }

    private ApplyResult failError(IOException e) {
        return ApplyResult.fail("[FATAL] Error while trying to write `" + this.relativePath + "`. Reason :" + e.getMessage());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifiedFileDiff that = (ModifiedFileDiff)o;
        return Objects.equals(this.diff, that.diff) && Objects.equals(this.relativePath, that.relativePath) && Objects.equals(this.originalLines, that.originalLines) && Objects.equals(this.original, that.original);
    }

    public int hashCode() {
        return Objects.hash(this.diff, this.relativePath, this.originalLines, this.original);
    }
}

