/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.client.diff;

import java.io.File;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import org.mule.api.vcs.client.diff.ApplyResult;
import org.mule.api.vcs.client.diff.Conflict;
import org.mule.api.vcs.client.diff.Diff;
import org.mule.api.vcs.client.diff.FileUtils;
import org.mule.api.vcs.client.diff.MergeOperation;
import org.mule.api.vcs.client.diff.MergingStrategy;
import org.mule.api.vcs.client.service.BranchRepositoryManager;

public class NewFileConflictDiff
implements Diff,
Conflict {
    private List<String> theirs;
    private List<String> ours;
    private String relativePath;

    public NewFileConflictDiff(List<String> theirs, List<String> ours, String relativePath) {
        this.theirs = theirs;
        this.ours = ours;
        this.relativePath = relativePath;
    }

    @Override
    public ApplyResult apply(File targetDirectory, MergingStrategy mergingStrategy) {
        return ApplyResult.fail("Merge conflicts can not be applied");
    }

    public List<String> getTheirs() {
        return this.theirs;
    }

    public List<String> getOurs() {
        return this.ours;
    }

    @Override
    public void print(PrintWriter printWriter) {
    }

    @Override
    public void push(BranchRepositoryManager branch, File targetDirectory) {
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public MergeOperation getOperationType() {
        return MergeOperation.NEW_FILE_CONFLICT;
    }

    @Override
    public ApplyResult unApply(File targetDirectory) {
        return ApplyResult.fail("NewFile conflicts can not be un applied");
    }

    @Override
    public ApplyResult resolve(File targetDirectory, MergingStrategy mergingStrategy) {
        File theirsFile = new File(targetDirectory, this.relativePath + ".theirs");
        switch (mergingStrategy) {
            case KEEP_OURS: {
                theirsFile.delete();
                return ApplyResult.SUCCESSFUL;
            }
            case KEEP_THEIRS: {
                FileUtils.writeFile(targetDirectory, this.relativePath, this.theirs);
                theirsFile.delete();
                return ApplyResult.SUCCESSFUL;
            }
        }
        return ApplyResult.fail("NewFile Conflict doesn't support " + mergingStrategy.name());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewFileConflictDiff that = (NewFileConflictDiff)o;
        return Objects.equals(this.theirs, that.theirs) && Objects.equals(this.ours, that.ours) && Objects.equals(this.relativePath, that.relativePath);
    }

    public int hashCode() {
        return Objects.hash(this.theirs, this.ours, this.relativePath);
    }
}

