/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.client.diff;

import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.InsertDelta;
import com.github.difflib.patch.Patch;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.mule.api.vcs.client.BranchInfo;
import org.mule.api.vcs.client.diff.ApplyResult;
import org.mule.api.vcs.client.diff.Diff;
import org.mule.api.vcs.client.diff.MergeOperation;
import org.mule.api.vcs.client.diff.MergingStrategy;
import org.mule.api.vcs.client.service.BranchRepositoryManager;

public class NewFileDiff
implements Diff {
    private byte[] content;
    private String relativePath;

    public NewFileDiff(byte[] content, String relativePath) {
        this.content = content;
        this.relativePath = relativePath;
    }

    @Override
    public ApplyResult apply(File targetDirectory, MergingStrategy mergingStrategy) {
        File file = new File(targetDirectory, this.relativePath);
        if (file.exists()) {
            switch (mergingStrategy) {
                case KEEP_BOTH: {
                    this.createFile(new File(targetDirectory, this.relativePath + ".theirs"));
                    break;
                }
                case KEEP_THEIRS: {
                    this.createFile(file);
                }
            }
            return ApplyResult.fail("File already exists " + file.getAbsolutePath() + ". Resolution strategy applied was : " + (Object)((Object)mergingStrategy));
        }
        return this.createFile(file);
    }

    private ApplyResult createFile(File file) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(this.content);
        }
        catch (IOException e) {
            return ApplyResult.fail("Unable to create file " + e.getMessage());
        }
        return ApplyResult.SUCCESSFUL;
    }

    @Override
    public void print(PrintWriter printWriter) {
        printWriter.println("Index: " + this.relativePath);
        printWriter.println("===================================================================");
        Patch patch = new Patch();
        patch.addDelta((AbstractDelta)new InsertDelta(new Chunk(0, (Object[])new String[0]), new Chunk(0, (Object[])this.getLines())));
        List stringList = UnifiedDiffUtils.generateUnifiedDiff((String)this.relativePath, (String)this.relativePath, new ArrayList(), (Patch)patch, (int)2);
        for (String line : stringList) {
            printWriter.println(line);
        }
    }

    private String[] getLines() {
        String content = new String(this.content, BranchInfo.DEFAULT_CHARSET);
        return content.split("\n");
    }

    @Override
    public void push(BranchRepositoryManager branch, File targetDirectory) {
        File file = new File(targetDirectory, this.relativePath);
        try {
            String type = Files.probeContentType(file.toPath());
            branch.newFile(this.relativePath, Files.readAllBytes(file.toPath()), type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public MergeOperation getOperationType() {
        return MergeOperation.NEW_FILE;
    }

    @Override
    public ApplyResult unApply(File targetDirectory) {
        File file = new File(targetDirectory, this.relativePath);
        boolean deleted = file.delete();
        if (deleted) {
            return ApplyResult.SUCCESSFUL;
        }
        return ApplyResult.fail("Unable to delete `" + this.relativePath + "`");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewFileDiff that = (NewFileDiff)o;
        return Arrays.equals(this.content, that.content) && Objects.equals(this.relativePath, that.relativePath);
    }

    public int hashCode() {
        int result = Objects.hash(this.relativePath);
        result = 31 * result + Arrays.hashCode(this.content);
        return result;
    }
}

