/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.client.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.api.vcs.client.BranchInfo;
import org.mule.api.vcs.client.service.ApiFile;
import org.mule.api.vcs.client.service.ApiFileContent;
import org.mule.api.vcs.client.service.ApiFileType;
import org.mule.api.vcs.client.service.BranchRepositoryManager;
import org.mule.api.vcs.client.service.UserInfoProvider;
import org.mule.apidesigner.model.FileContent;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.Branch;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.files.filePath.model.FilePathDELETEHeader;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.files.filePath.model.FilePathGETHeader;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.files.model.FilesGETHeader;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.save.model.SavePOSTHeader;
import org.mule.apidesigner.responses.ApiDesignerXapiResponse;

public class ApiManagerBranchManager
implements BranchRepositoryManager {
    private final UserInfoProvider provider;
    private final Branch branch;

    public ApiManagerBranchManager(UserInfoProvider provider, Branch branch) {
        this.provider = provider;
        this.branch = branch;
    }

    @Override
    public boolean delete(String path) {
        ApiDesignerXapiResponse delete = this.branch.files.filePath(path).delete(new FilePathDELETEHeader(this.provider.getOrgId(), this.provider.getUserId()), this.provider.getAccessToken());
        return true;
    }

    @Override
    public boolean newFile(String path, byte[] content, String mimeType) {
        return this.doSave(path, content);
    }

    private boolean doSave(String path, byte[] content) {
        String fileContent = new String(content, BranchInfo.DEFAULT_CHARSET);
        List<FileContent> fileContents = Collections.singletonList(new FileContent(path, fileContent));
        ApiDesignerXapiResponse post = this.branch.save.post(fileContents, new SavePOSTHeader(this.provider.getOrgId(), this.provider.getUserId()), this.provider.getAccessToken());
        return true;
    }

    @Override
    public boolean updateFile(String path, byte[] content) {
        return this.doSave(path, content);
    }

    @Override
    public List<ApiFile> listFiles() {
        List fileList = (List)this.branch.files.get(new FilesGETHeader(this.provider.getOrgId(), this.provider.getUserId()), this.provider.getAccessToken()).getBody();
        return fileList.stream().filter(file -> file.getType().equalsIgnoreCase("FILE")).map(file -> new ApiFile(file.getPath(), ApiFileType.valueOf(file.getType()))).collect(Collectors.toList());
    }

    @Override
    public ApiFileContent fileContent(String path) {
        ApiDesignerXapiResponse stringApiDesignerXapiResponse = this.branch.files.filePath(path).get(new FilePathGETHeader(this.provider.getOrgId(), this.provider.getUserId()), this.provider.getAccessToken());
        String body = (String)stringApiDesignerXapiResponse.getBody();
        return new ApiFileContent(body.getBytes(BranchInfo.DEFAULT_CHARSET), stringApiDesignerXapiResponse.getResponse().getMediaType().toString());
    }
}

