/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.vcs.client.service.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.api.vcs.client.BranchInfo;
import org.mule.api.vcs.client.PublishInfo;
import org.mule.api.vcs.client.service.ApiBranch;
import org.mule.api.vcs.client.service.ApiType;
import org.mule.api.vcs.client.service.BranchRepositoryLock;
import org.mule.api.vcs.client.service.ProjectInfo;
import org.mule.api.vcs.client.service.RepositoryFileManager;
import org.mule.api.vcs.client.service.UserInfoProvider;
import org.mule.api.vcs.client.service.impl.ApiManagerBranchManager;
import org.mule.apidesigner.api.ApiDesignerXapiClient;
import org.mule.apidesigner.exceptions.ApiDesignerXapiException;
import org.mule.apidesigner.model.Lock;
import org.mule.apidesigner.model.Project;
import org.mule.apidesigner.model.ProjectCreate;
import org.mule.apidesigner.resource.projects.model.ProjectsGETHeader;
import org.mule.apidesigner.resource.projects.model.ProjectsPOSTHeader;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.Branch;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.acquireLock.model.AcquireLockPOSTHeader;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.publish.exchange.model.ExchangePOSTBody;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.publish.exchange.model.ExchangePOSTHeader;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.publish.exchange.model.Metadata;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.releaseLock.model.ReleaseLockPOSTHeader;
import org.mule.apidesigner.resource.projects.projectId.branches.model.BranchesGETHeader;
import org.mule.apidesigner.responses.ApiDesignerXapiResponse;

public class ApiRepositoryFileManager
implements RepositoryFileManager {
    private ApiDesignerXapiClient client;

    public ApiRepositoryFileManager() {
        this.client = ApiDesignerXapiClient.create();
    }

    public ApiRepositoryFileManager(String url) {
        this.client = ApiDesignerXapiClient.create((String)url);
    }

    @Override
    public BranchRepositoryLock acquireLock(UserInfoProvider provider, String projectId, String branchName) {
        try {
            String userId = provider.getUserId();
            String accessToken = provider.getAccessToken();
            String orgId = provider.getOrgId();
            Branch branch = this.client.projects.projectId((String)projectId).branches.branch(branchName);
            ApiDesignerXapiResponse post = branch.acquireLock.post(new AcquireLockPOSTHeader(orgId, userId), accessToken);
            Boolean locked = ((Lock)post.getBody()).getLocked();
            ApiManagerBranchManager branchManager = new ApiManagerBranchManager(provider, branch);
            return new BranchRepositoryLock(locked, ((Lock)post.getBody()).getName(), branchManager);
        }
        catch (ApiDesignerXapiException e) {
            throw new RuntimeException(e.getReason());
        }
    }

    @Override
    public void releaseLock(UserInfoProvider provider, String projectId, String branchName) {
        this.client.projects.projectId((String)projectId).branches.branch((String)branchName).releaseLock.post(new ReleaseLockPOSTHeader(provider.getOrgId(), provider.getUserId()), provider.getAccessToken());
    }

    @Override
    public List<ApiBranch> branches(UserInfoProvider provider, String projectId) {
        ApiDesignerXapiResponse response = this.client.projects.projectId((String)projectId).branches.get(new BranchesGETHeader(provider.getOrgId(), provider.getUserId()), provider.getAccessToken());
        return ((List)response.getBody()).stream().map(branch -> new ApiBranch(branch.getName())).collect(Collectors.toList());
    }

    @Override
    public List<ProjectInfo> projects(UserInfoProvider provider) {
        ApiDesignerXapiResponse response = this.client.projects.get(new ProjectsGETHeader(provider.getOrgId(), provider.getUserId()), provider.getAccessToken());
        return ((List)response.getBody()).stream().filter(p -> !p.getType().equalsIgnoreCase("Mule_Application")).map(p -> new ProjectInfo(p.getId(), p.getName(), p.getDescription())).collect(Collectors.toList());
    }

    @Override
    public BranchInfo create(UserInfoProvider provider, ApiType apiType, String name, String description) {
        ApiDesignerXapiResponse post = this.client.projects.post(new ProjectCreate(name, description, apiType.getType()), new ProjectsPOSTHeader(provider.getOrgId(), provider.getUserId()), provider.getAccessToken());
        return new BranchInfo(((Project)post.getBody()).getId(), "master", provider.getOrgId());
    }

    @Override
    public void publish(UserInfoProvider provider, PublishInfo publishInfo) {
        ExchangePOSTBody exchangePOSTBody = new ExchangePOSTBody();
        exchangePOSTBody.setApiVersion(publishInfo.getApiVersion());
        exchangePOSTBody.setAssetId(publishInfo.getAssetId());
        exchangePOSTBody.setGroupId(publishInfo.getGroupId());
        exchangePOSTBody.setClassifier(publishInfo.getClassifier());
        exchangePOSTBody.setName(publishInfo.getName());
        exchangePOSTBody.setMain(publishInfo.getMain());
        exchangePOSTBody.setVersion(publishInfo.getVersion());
        exchangePOSTBody.setMetadata(new Metadata(publishInfo.getBranchInfo().getProjectId(), publishInfo.getBranchInfo().getBranch()));
        this.client.projects.projectId((String)publishInfo.getBranchInfo().getProjectId()).branches.branch((String)publishInfo.getBranchInfo().getBranch()).publish.exchange.post(exchangePOSTBody, new ExchangePOSTHeader(provider.getOrgId(), provider.getUserId()), provider.getAccessToken());
    }
}

