/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.mule.devkit.tooling.GitService;
import org.mule.devkit.tooling.generator.DemoFileGenerator;
import org.mule.devkit.tooling.generator.FunctionalDocGenerator;
import org.mule.devkit.tooling.generator.Generator;
import org.mule.devkit.tooling.generator.IndexPageGenerator;
import org.mule.devkit.tooling.model.Version;

@Mojo(name="pack")
public class ApiDocDeployMojo
extends AbstractMojo {
    private static final String APIDOCS = "apidocs";
    @Parameter(defaultValue="false", property="push")
    private Boolean push;
    @Parameter(defaultValue="", property="prefix")
    private String prefix;
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(defaultValue="true", required=true, property="generate.functional")
    private boolean hasFunctional;
    @Parameter(defaultValue="true", required=true, property="merge")
    private boolean merge;
    private final List<Version> versions = new ArrayList<Version>();
    private Path workingDir;
    private Path apidocDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.apidocDir = Paths.get(this.project.getBuild().getDirectory(), APIDOCS).toAbsolutePath();
        if (!this.apidocDir.toFile().exists()) {
            throw new MojoFailureException("Error while searching for apidocs: " + this.apidocDir + " dir not found. Run mvn javadoc:javadoc to generate the connector apidocs");
        }
        if (this.project.getVersion().contains("SNAPSHOT") || this.project.getVersion().contains("RC")) {
            throw new MojoFailureException("Version must be final. SNAPSHOT or RC versions cannot be upload");
        }
        this.workingDir = this.findWorkingDir();
        System.console().printf("Username: ", new Object[0]);
        String user = System.console().readLine();
        System.console().printf("Password: ", new Object[0]);
        String password = new String(System.console().readPassword());
        GitService service = new GitService(this.workingDir, user, password);
        try {
            String projectDirName = this.project.getBasedir().getName();
            service.checkoutGhPages();
            if (!this.isFollowingConvention() && this.merge) {
                this.getLog().warn((CharSequence)"gh-pages branch is not following the connector-doc convention. Check out the plugin docs");
                this.merge = this.askForOverride(service);
            }
            if (this.merge) {
                this.getLog().info((CharSequence)"Merging with previous content");
                this.versions.addAll(this.getOldVersions());
            } else {
                this.getLog().info((CharSequence)"Cleaning previous content");
                service.cleanDir(this.workingDir.toFile(), projectDirName);
            }
            service.checkoutBase();
            this.versions.add(this.getCurrentVersion());
            for (Generator generator : this.getGenerators()) {
                if (!generator.shouldGenerate()) continue;
                this.getLog().info((CharSequence)("Executing " + generator.getClass().getSimpleName()));
                generator.generate(this.project, this.workingDir.toString());
            }
            service.checkoutGhPages();
            this.unpackFiles(this.createNewVersionFolder(service));
            if (!projectDirName.equals(this.workingDir.toFile().getName())) {
                service.remove(projectDirName);
            }
            service.remove("target");
            service.addAll();
            this.getLog().info((CharSequence)"Generating commit with the docs update");
            service.commit("Update docs - Version " + this.project.getVersion());
            if (this.push.booleanValue()) {
                this.getLog().info((CharSequence)"Pushing changes");
                service.push();
            }
        }
        finally {
            service.checkoutBase();
        }
    }

    private Path findWorkingDir() {
        File workingDir = this.project.getBasedir();
        for (int tries = 0; !new File(workingDir, ".git").exists() && tries < 3; ++tries) {
            workingDir = workingDir.getParentFile();
        }
        return workingDir.toPath();
    }

    private Version getCurrentVersion() {
        return Version.getBuilder().setVersion(this.project.getVersion()).hasFunctionalDoc(this.hasFunctional).setDemos(this.getDemoNames(this.project.getBasedir())).build();
    }

    private List<Version> getOldVersions() throws MojoExecutionException {
        ArrayList<Version> oldVersions = new ArrayList<Version>();
        File[] files = this.workingDir.toFile().listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() || !this.isVersionName(file.getName()) || file.getName().equalsIgnoreCase(this.project.getVersion())) continue;
                oldVersions.add(Version.getBuilder().setVersion(file.getName()).hasFunctionalDoc(this.hasFunctionalDocFolder(file)).setDemos(this.getDemoNames(file)).build());
            }
        }
        return oldVersions;
    }

    private List<String> getDemoNames(File versionDir) {
        File[] files;
        ArrayList<String> demos = new ArrayList<String>();
        File demoDir = Paths.get(versionDir.getAbsolutePath(), "demo").toFile();
        if (demoDir.exists() && (files = demoDir.listFiles()) != null) {
            for (File demo : files) {
                demos.add(demo.getName() + ".zip");
            }
        }
        return demos;
    }

    private Boolean hasFunctionalDocFolder(File versionDir) {
        return new File(versionDir.getAbsolutePath().concat(File.separator + "functional")).exists();
    }

    private boolean askForOverride(GitService service) throws MojoExecutionException {
        System.console().printf("[INFO] Do you want to override all the information? all the previous content will be erased y/n: ", new Object[0]);
        String answer = System.console().readLine();
        while (!answer.startsWith("y") && !answer.startsWith("n")) {
            System.console().printf("[WARNING] y/n: ", new Object[0]);
            answer = System.console().readLine();
        }
        if (answer.startsWith("n")) {
            service.checkoutBase();
            throw new RuntimeException("Interrupted by the user. Make gh-pages branch follow the convention or override the content");
        }
        return false;
    }

    private File createNewVersionFolder(GitService service) throws MojoFailureException {
        Path versionDir = !StringUtils.isBlank((String)this.prefix) ? Paths.get(this.workingDir.toString(), this.prefix, this.project.getVersion()) : Paths.get(this.workingDir.toString(), this.project.getVersion());
        try {
            if (!versionDir.toFile().exists()) {
                Files.createDirectories(versionDir, new FileAttribute[0]);
                this.getLog().info((CharSequence)("Folder created: " + versionDir.toString()));
            } else {
                String removePattern = versionDir.getFileName() + File.separator + "*";
                service.remove(StringUtils.isBlank((String)this.prefix) ? removePattern : this.prefix + File.separator + removePattern);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Could not create version " + this.project.getVersion() + " folder: " + e.getMessage(), (Throwable)e);
        }
        return versionDir.toFile();
    }

    private List<Generator> getGenerators() {
        ArrayList<Generator> generators = new ArrayList<Generator>();
        generators.add(new FunctionalDocGenerator(this.hasFunctional));
        generators.add(new DemoFileGenerator(this.getCurrentVersion()));
        generators.add(new IndexPageGenerator(this.versions));
        return generators;
    }

    private void unpackFiles(File versionDir) throws MojoFailureException {
        this.getLog().info((CharSequence)"Unpacking generated files");
        try {
            String[] RESOURCE_FILES;
            File generatedSources = new File(this.workingDir.toFile(), "target");
            FileUtils.copyDirectory((File)this.apidocDir.toFile(), (File)new File(versionDir, APIDOCS));
            File generatedDemoDir = new File(generatedSources, "demo");
            if (generatedDemoDir.exists()) {
                FileUtils.copyDirectory((File)generatedDemoDir, (File)new File(versionDir, "demo"));
            }
            File generatedFunctionalDir = new File(generatedSources, "functional");
            if (this.hasFunctional && generatedFunctionalDir.exists()) {
                FileUtils.copyDirectory((File)generatedFunctionalDir, (File)new File(versionDir, "functional"));
            }
            File generatedIndex = new File(generatedSources, "index.html");
            FileUtils.copyFile((File)generatedIndex, (File)new File(this.workingDir.toFile(), "index.html"));
            for (String resource : RESOURCE_FILES = new String[]{"index.png", "index.js", "index.css", "icon.png"}) {
                File resourceFile = new File(this.workingDir.toFile(), resource);
                if (resourceFile.exists()) continue;
                InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + resource);
                FileUtils.copyInputStreamToFile((InputStream)resourceAsStream, (File)resourceFile);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error while unpacking generated files : " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean isFollowingConvention() throws MojoExecutionException {
        Boolean hasVersions = false;
        Boolean hasIndexHTML = false;
        Boolean hasIndexCss = false;
        File[] files = this.workingDir.toFile().listFiles();
        if (files != null) {
            for (File file : files) {
                if (this.isVersionName(file.getName())) {
                    hasVersions = true;
                }
                if ("index.html".equals(file.getName())) {
                    hasIndexHTML = true;
                }
                if (!"index.css".equalsIgnoreCase(file.getName())) continue;
                hasIndexCss = true;
            }
        } else {
            throw new MojoExecutionException("Error while retrieving files in Convention Searcher");
        }
        return hasIndexCss != false && hasIndexHTML != false && hasVersions != false;
    }

    private boolean isVersionName(String name) {
        return name.matches("\\d+\\.\\d+\\.*\\d*");
    }
}

