/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.project.MavenProject;
import org.mule.devkit.tooling.exceptions.GenerationException;
import org.mule.devkit.tooling.generator.Generator;
import org.mule.devkit.tooling.model.Version;

public class DemoFileGenerator
implements Generator {
    private static final String ZIP_SUFFIX = ".zip";
    private final String DEMO_FOLDER = "demo";
    private Version current;

    public DemoFileGenerator(Version current) {
        this.current = current;
    }

    @Override
    public boolean shouldGenerate() {
        return !this.current.getDemos().isEmpty();
    }

    @Override
    public void generate(MavenProject project, String workingDir) {
        String filesDir = Paths.get(project.getBasedir().toString(), "demo").toString();
        DemoFileGenerator.zipDemos(filesDir, this.getOutputDir(workingDir).toString());
    }

    @Override
    public Path getOutputDir(String workingDir) {
        Path output = Paths.get(workingDir, "target", "demo");
        if (!output.toFile().exists()) {
            try {
                Files.createDirectory(output, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new GenerationException("Could not create demo files generation directory: " + e.getMessage(), e);
            }
        }
        return output;
    }

    public static void zipDemos(String dirPath, String outputDir) {
        File directory = new File(dirPath);
        File[] files = directory.listFiles();
        if (files != null) {
            for (File demo : files) {
                if (!demo.isDirectory()) continue;
                DemoFileGenerator.zipDemo(demo, outputDir);
            }
        }
    }

    private static void zipDemo(File directory, String outputDir) {
        byte[] buffer = new byte[1024];
        try {
            FileOutputStream fos = new FileOutputStream(outputDir + File.separator + directory.getName() + ZIP_SUFFIX);
            ZipOutputStream zos = new ZipOutputStream(fos);
            List<String> fileList = DemoFileGenerator.getDirFiles(directory, new ArrayList<String>());
            for (String file : fileList) {
                int len;
                ZipEntry ze = new ZipEntry(file.substring(file.indexOf("demo")));
                zos.putNextEntry(ze);
                FileInputStream in = new FileInputStream(file);
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                in.close();
            }
            zos.closeEntry();
            zos.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not zip demo. An error occur while writing the file");
        }
    }

    private static List<String> getDirFiles(File node, List<String> fileList) {
        if (node.isFile()) {
            fileList.add(node.getPath());
        }
        if (node.isDirectory()) {
            String[] subNode;
            for (String filename : subNode = node.list()) {
                DemoFileGenerator.getDirFiles(new File(node, filename), fileList);
            }
        }
        return fileList;
    }
}

