/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling.generator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.mule.devkit.tooling.exceptions.GenerationException;
import org.mule.devkit.tooling.generator.Generator;

public class FunctionalDocGenerator
implements Generator {
    private Properties props = new Properties();
    private final boolean process;

    public FunctionalDocGenerator(boolean process) {
        this.process = process;
    }

    @Override
    public boolean shouldGenerate() {
        return this.process;
    }

    @Override
    public void generate(MavenProject project, String workingDir) {
        File adocFile = Paths.get(project.getBasedir().toString(), "doc", "user-manual.adoc").toFile();
        if (!adocFile.exists()) {
            throw new GenerationException("user-manual.adoc file does not exist in /doc: expected [" + adocFile.getAbsolutePath() + "] file could not be found.");
        }
        try {
            InputStream is = this.getClass().getResourceAsStream("/functional-style.css");
            FileUtils.copyInputStreamToFile((InputStream)is, (File)Paths.get(workingDir, "target", "style.css").toFile());
            this.props.setProperty("connector.dir", project.getBasedir().toString());
            this.props.setProperty("working.dir", workingDir);
            File pluginPomFile = this.getPluginPomFile();
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setPomFile(pluginPomFile).setProperties(this.props).setGoals(Collections.singletonList("compile"));
            new DefaultInvoker().execute((InvocationRequest)request);
        }
        catch (IOException e) {
            throw new GenerationException("Could not generate functional doc | run -Dgenerate.functional=false to skip. ERROR: " + e.getMessage(), e);
        }
        catch (MavenInvocationException e) {
            throw new GenerationException("Resource file plugin-pom.xml not found: " + e.getMessage(), e);
        }
    }

    @Override
    public Path getOutputDir(String workingDir) {
        return Paths.get(workingDir, "functional").toAbsolutePath();
    }

    private File getPluginPomFile() throws IOException {
        File pomFile = File.createTempFile("plugin-pom", ".xml");
        FileUtils.copyInputStreamToFile((InputStream)this.getClass().getResourceAsStream("/plugin-pom.xml"), (File)pomFile);
        return pomFile;
    }
}

