/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.egit.github.core.Blob;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.CommitUser;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Reference;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.Tree;
import org.eclipse.egit.github.core.TreeEntry;
import org.eclipse.egit.github.core.TypedResource;
import org.eclipse.egit.github.core.service.DataService;
import org.eclipse.egit.github.core.util.EncodingUtils;
import org.mule.devkit.tooling.GitHubPagesUtils;
import org.mule.devkit.tooling.PathUtils;
import org.mule.devkit.tooling.RepositoryUtils;
import org.mule.devkit.tooling.exceptions.GithubException;
import org.mule.devkit.tooling.exceptions.GithubRequestException;
import org.mule.devkit.tooling.exceptions.IndexGenerationException;
import org.mule.devkit.tooling.exceptions.RepositoryCreationException;
import org.mule.devkit.tooling.html.generation.IndexBuilder;

@Mojo(name="deploy")
public class GitHubPagesDeployMojo
extends AbstractMojo {
    private static final String BRANCH = "gh-pages";
    private static final String BRANCH_DEFAULT = "refs/heads/gh-pages";
    private static final int BUFFER_LENGTH = 8192;
    private static final String HOST = "api.github.com";
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(property="docsDirectory", defaultValue="${project.build.directory}/apidocs", required=true)
    private File docsDirectory;
    @Parameter(property="demosDirectory", defaultValue="${project.basedir}/demo")
    private File demosDirectory;
    @Parameter(required=true, property="version", defaultValue="${project.version}")
    private String version;
    @Parameter(defaultValue="${project.scm.url}")
    private String repositoryUrl;
    @Parameter(property="includes")
    private String[] includes;
    @Parameter(property="excludes")
    private String[] excludes = new String[]{"**/current.xml"};
    @Parameter(required=true, defaultValue="true", property="merge")
    private boolean merge;
    @Parameter(defaultValue="Connector Documentation Deploy", property="message")
    private String message;
    @Parameter(required=true, property="user")
    private String user;
    @Parameter(required=true, property="password")
    private String password;
    @Parameter(property="repositoryOwner")
    private String repositoryOwner;
    @Parameter(property="repositoryName")
    private String repositoryName;

    public void execute() throws MojoExecutionException {
        if (this.version.contains("SNAPSHOT")) {
            throw new MojoExecutionException("version can not be a SNAPSHOT");
        }
        try {
            RepositoryId repository = RepositoryUtils.getRepositoryId(this.repositoryName, this.repositoryOwner, this.repositoryUrl);
            if (GitHubPagesUtils.useScm(this.repositoryName, this.repositoryOwner)) {
                this.repositoryName = RepositoryUtils.getRepositoryNameFromUrl(this.repositoryUrl);
                this.repositoryOwner = RepositoryUtils.getRepositoryOwnerFromUrl(this.repositoryUrl);
            }
            DataService service = new DataService(RepositoryUtils.createClient(HOST, this.user, this.password));
            Reference ref = RepositoryUtils.getReference(repository, service, BRANCH_DEFAULT);
            RepositoryUtils.checkBranchIsCreated(this.repositoryName, this.repositoryOwner, BRANCH, this.user, this.password, this.merge);
            ArrayList<TreeEntry> entries = new ArrayList<TreeEntry>();
            List<String> versions = GitHubPagesUtils.getPreviousDocVersions(service, repository, ref, this.version, this.user, this.password, this.merge);
            Map<String, List<String>> demosMap = GitHubPagesUtils.getDemosNames(service, repository, ref, this.demosDirectory, this.version, this.user, this.password, this.merge);
            entries.add(this.createIndexHtmlBlob(repository, service, versions, demosMap));
            entries.add(this.createBlobFromResourceFile(repository, service, "index", ".css"));
            entries.add(this.createBlobFromResourceFile(repository, service, "index", ".png"));
            this.createBlobs(repository, service, PathUtils.getFilesToInclude(this.docsDirectory, this.includes, this.excludes), PathUtils.getPrefix(this.version), this.docsDirectory, entries);
            if (this.demosDirectory.exists()) {
                this.createBlobs(repository, service, PathUtils.getFilesToInclude(this.demosDirectory), PathUtils.getPrefix(this.version) + "demo/", this.demosDirectory, entries);
            } else {
                this.warn("/demo directory does exists.");
            }
            Tree tree = this.writeTree(repository, service, entries, ref);
            CommitUser committer = RepositoryUtils.getCommitUser(this.user);
            Commit commit = RepositoryUtils.buildCommit(tree, committer, this.message);
            if (ref != null) {
                commit.setParents(Collections.singletonList(new Commit().setSha(ref.getObject().getSha())));
            }
            Commit created = RepositoryUtils.createCommit(repository, service, commit);
            this.info(MessageFormat.format("Creating commit with SHA-1: {0}", created.getSha()));
            this.updateReference(ref, commit, service, created, repository);
        }
        catch (GithubException | GithubRequestException | RepositoryCreationException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void info(String message) {
        Log log = this.getLog();
        if (log != null) {
            log.info((CharSequence)message);
        }
    }

    protected void warn(String message) {
        Log log = this.getLog();
        if (log != null) {
            log.warn((CharSequence)message);
        }
    }

    private Tree writeTree(RepositoryId repository, DataService service, List<TreeEntry> entries, Reference ref) throws MojoExecutionException {
        Tree tree;
        this.info(MessageFormat.format("Creating a tree with {0} blob entries", entries.size()));
        String baseTree = null;
        try {
            if (this.merge && ref != null) {
                Tree currentTree = service.getCommit((IRepositoryIdProvider)repository, ref.getObject().getSha()).getTree();
                if (currentTree != null) {
                    baseTree = currentTree.getSha();
                }
                this.info(MessageFormat.format("Merging with tree {0}", baseTree));
            }
            tree = service.createTree((IRepositoryIdProvider)repository, entries, baseTree);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating tree: " + e.getMessage(), (Exception)e);
        }
        return tree;
    }

    private TreeEntry createIndexHtmlBlob(RepositoryId repository, DataService service, List<String> versions, Map<String, List<String>> map) throws MojoExecutionException {
        this.info("Creating index.html blob");
        IndexBuilder indexBuilder = new IndexBuilder(versions, GitHubPagesUtils.getDocLink(this.repositoryOwner, this.repositoryName), this.project.getName(), map);
        File indexHtml = null;
        try {
            indexHtml = indexBuilder.generateHtmlFile();
        }
        catch (IndexGenerationException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }
        return this.createTreeEntry(repository, service, indexHtml, "index.html");
    }

    private TreeEntry createBlobFromResourceFile(RepositoryId repository, DataService service, String fileName, String suffix) throws MojoExecutionException {
        this.info(MessageFormat.format("Creating {0}{1} blob", fileName, suffix));
        InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + fileName + suffix);
        File file = null;
        try {
            file = File.createTempFile(fileName, suffix);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }
        try {
            FileUtils.copyInputStreamToFile((InputStream)resourceAsStream, (File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.createTreeEntry(repository, service, file, fileName + suffix);
    }

    private List<TreeEntry> createBlobs(RepositoryId repository, DataService service, String[] paths, String prefix, File baseDir, List<TreeEntry> entries) throws MojoExecutionException {
        this.info(MessageFormat.format("Creating {0} blobs", paths.length));
        for (String path : paths) {
            TreeEntry entry = this.createTreeEntry(repository, service, baseDir, path, prefix);
            entries.add(entry);
        }
        return entries;
    }

    private void updateReference(Reference ref, Commit commit, DataService service, Commit created, RepositoryId repository) throws MojoExecutionException {
        TypedResource object = new TypedResource();
        object.setType("commit").setSha(created.getSha());
        if (ref != null) {
            ref.setObject(object);
            try {
                this.info(MessageFormat.format("Updating reference {0} from {1} to {2}", BRANCH_DEFAULT, ((Commit)commit.getParents().get(0)).getSha(), created.getSha()));
                service.editReference((IRepositoryIdProvider)repository, ref, true);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error editing reference: " + e.getMessage(), (Exception)e);
            }
        }
        ref = new Reference().setObject(object).setRef(BRANCH_DEFAULT);
        try {
            this.info(MessageFormat.format("Creating reference {0} starting at commit {1}", BRANCH_DEFAULT, created.getSha()));
            service.createReference((IRepositoryIdProvider)repository, ref);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating reference: " + e.getMessage(), (Exception)e);
        }
    }

    private String createBlobFromDirectoryAndPath(DataService service, RepositoryId repository, String path, File directory) throws MojoExecutionException {
        File file = new File(directory, path);
        return this.createBlob(service, repository, file);
    }

    private String createBlob(DataService service, RepositoryId repository, File file) throws MojoExecutionException {
        long length = file.length();
        int size = length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length;
        ByteArrayOutputStream output = new ByteArrayOutputStream(size);
        FileInputStream stream = null;
        try {
            int read;
            stream = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            while ((read = stream.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error reading file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        Blob blob = new Blob().setEncoding("base64");
        blob.setContent(EncodingUtils.toBase64((byte[])output.toByteArray()));
        try {
            return this.uploadBlobRetryIfError(service, repository, blob);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating blob: " + e.getMessage(), (Exception)e);
        }
    }

    private String uploadBlobRetryIfError(DataService service, RepositoryId repository, Blob blob) throws IOException, MojoExecutionException {
        for (int i = 0; i < 3; ++i) {
            try {
                String resultBlob = service.createBlob((IRepositoryIdProvider)repository, blob);
                return resultBlob;
            }
            catch (IOException e) {
                continue;
            }
        }
        throw new MojoExecutionException("Cannot upload documentation to GitHub after retrying");
    }

    private TreeEntry createTreeEntry(RepositoryId repository, DataService service, File file, String fileSpecificPath, String prefix) throws MojoExecutionException {
        TreeEntry entry = new TreeEntry();
        entry.setPath(prefix + fileSpecificPath);
        entry.setType("blob");
        entry.setMode("100644");
        String blob = null;
        blob = !prefix.isEmpty() ? this.createBlobFromDirectoryAndPath(service, repository, fileSpecificPath, file) : this.createBlob(service, repository, file);
        entry.setSha(blob);
        return entry;
    }

    private TreeEntry createTreeEntry(RepositoryId repository, DataService service, File file, String name) throws MojoExecutionException {
        return this.createTreeEntry(repository, service, file, name, "");
    }
}

