/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Reference;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.service.DataService;
import org.mule.devkit.tooling.PathUtils;
import org.mule.devkit.tooling.RepositoryUtils;
import org.mule.devkit.tooling.exceptions.GithubRequestException;
import org.mule.devkit.tooling.github.model.TreeModel;

public class GitHubPagesUtils {
    public static List<String> getPreviousDocVersions(DataService service, RepositoryId repository, Reference ref, String version, String user, String password, boolean merge) throws GithubRequestException {
        ArrayList<String> versions = new ArrayList<String>();
        if (merge) {
            List<TreeModel> treeList;
            try {
                String url = service.getCommit((IRepositoryIdProvider)repository, ref.getObject().getSha()).getTree().getUrl();
                treeList = RepositoryUtils.getTreeFromUrl(user, password, url);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new GithubRequestException(e.getMessage(), e);
            }
            for (TreeModel tree : treeList) {
                String path = tree.getPath();
                if (path.contains("index") || path.equals(version)) continue;
                versions.add(path);
            }
        }
        versions.add(version);
        Comparator comparator = Collections.reverseOrder();
        Collections.sort(versions, comparator);
        return versions;
    }

    public static Map<String, List<String>> getDemosNames(DataService service, RepositoryId repository, Reference ref, File demosDirectory, String version, String user, String password, boolean merge) throws GithubRequestException {
        ArrayList<String> demos = new ArrayList<String>();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String path : PathUtils.getFilesToInclude(demosDirectory)) {
            if (!(path = path.substring(path.lastIndexOf(File.separator) + 1)).endsWith(".zip")) continue;
            demos.add(path);
        }
        map.put(version, demos);
        if (merge) {
            String url = null;
            try {
                url = service.getCommit((IRepositoryIdProvider)repository, ref.getObject().getSha()).getTree().getUrl();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new GithubRequestException(e.getMessage(), e);
            }
            List<TreeModel> treeList = RepositoryUtils.getTreeFromUrl(user, password, url);
            List<TreeModel> finalTree = null;
            for (TreeModel versionTree : treeList) {
                demos = new ArrayList();
                if (versionTree.getPath().contains("index")) continue;
                List<TreeModel> demoTrees = RepositoryUtils.getTreeFromUrl(user, password, versionTree.getUrl());
                for (TreeModel demoTree : demoTrees) {
                    if (!demoTree.getPath().equals("demo")) continue;
                    finalTree = RepositoryUtils.getTreeFromUrl(user, password, demoTree.getUrl());
                    for (TreeModel tree : finalTree) {
                        String path = tree.getPath();
                        if (!path.endsWith(".zip")) continue;
                        demos.add(path);
                    }
                    map.put(versionTree.getPath(), demos);
                }
            }
        }
        return map;
    }

    public static String getDocLink(String repoOwner, String repoName) {
        return repoOwner + ".github.io/" + repoName;
    }

    public static boolean useScm(String repositoryName, String repositoryOwner) {
        return StringUtils.isEmpty((CharSequence)repositoryName) && StringUtils.isEmpty((CharSequence)repositoryOwner);
    }
}

