/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.codehaus.plexus.util.DirectoryScanner;

public class PathUtils {
    public static String[] removeEmpties(String ... values) {
        if (values == null || values.length == 0) {
            return new String[0];
        }
        ArrayList<String> validValues = new ArrayList<String>();
        for (String value : values) {
            if (value == null || value.length() <= 0) continue;
            validValues.add(value);
        }
        return validValues.toArray(new String[validValues.size()]);
    }

    public static String[] getMatchingPaths(String[] includes, String[] excludes, String baseDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir);
        if (includes != null && includes.length > 0) {
            scanner.setIncludes(includes);
        }
        if (excludes != null && excludes.length > 0) {
            scanner.setExcludes(excludes);
        }
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public static String getPrefix(String prefix) {
        if (prefix == null) {
            return "";
        }
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
            return prefix;
        }
        return null;
    }

    public static String[] getFilesToInclude(File baseDirectory, String[] includes, String[] excludes) {
        String baseDir = baseDirectory.getAbsolutePath();
        String[] includePaths = PathUtils.removeEmpties(includes);
        String[] excludePaths = PathUtils.removeEmpties(excludes);
        return PathUtils.getMatchingPaths(includePaths, excludePaths, baseDir);
    }

    public static String[] getFilesToInclude(File baseDirectory) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDirectory.getAbsolutePath());
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private void compressDemos(File demosDirectory) {
        File[] demoFiles = demosDirectory.listFiles();
        if (demoFiles == null) {
            return;
        }
        for (File demoFile : demoFiles) {
            if (!demoFile.isDirectory()) continue;
            try {
                int length;
                FileInputStream fis = new FileInputStream(demoFile);
                FileOutputStream fos = new FileOutputStream(demoFile.getName() + ".zip");
                ZipOutputStream zos = new ZipOutputStream(fos);
                String zipFilePath = demoFile.getCanonicalPath().substring(demosDirectory.getCanonicalPath().length() + 1, demoFile.getCanonicalPath().length());
                ZipEntry zipEntry = new ZipEntry(zipFilePath);
                zos.putNextEntry(zipEntry);
                byte[] bytes = new byte[1024];
                while ((length = fis.read(bytes)) >= 0) {
                    zos.write(bytes, 0, length);
                }
                zos.closeEntry();
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

