/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.CommitUser;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Reference;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.Tree;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.RequestException;
import org.eclipse.egit.github.core.service.DataService;
import org.eclipse.egit.github.core.service.UserService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.devkit.tooling.GitHubPagesUtils;
import org.mule.devkit.tooling.GithubRestcall;
import org.mule.devkit.tooling.exceptions.GithubException;
import org.mule.devkit.tooling.exceptions.GithubRequestException;
import org.mule.devkit.tooling.exceptions.RepositoryCreationException;
import org.mule.devkit.tooling.github.model.TreeModel;

public class RepositoryUtils {
    public static Commit buildCommit(Tree tree, CommitUser committer, String message) {
        Commit commit = new Commit();
        commit.setMessage(message);
        commit.setTree(tree);
        commit.setAuthor(committer);
        commit.setCommitter(committer);
        return commit;
    }

    public static CommitUser getCommitUser(String user) throws GithubException {
        CommitUser committer = new CommitUser();
        try {
            User current = new UserService().getUser(user);
            committer.setDate(Calendar.getInstance().getTime());
            committer.setName(current.getName());
            committer.setEmail(current.getEmail());
        }
        catch (IOException e) {
            throw new GithubException("Error retrieving github user information: " + e.getMessage(), e);
        }
        return committer;
    }

    public static RepositoryId getRepositoryId(String repositoryName, String repositoryOwner, String repositoryUrl) throws RepositoryCreationException {
        if (GitHubPagesUtils.useScm(repositoryName, repositoryOwner)) {
            return RepositoryUtils.getRepository(repositoryUrl);
        }
        return RepositoryUtils.getRepository(repositoryOwner, repositoryName);
    }

    public static RepositoryId getRepository(String url) throws RepositoryCreationException {
        if (StringUtils.isBlank((String)url)) {
            throw new RepositoryCreationException("Url is null. url attribute in scm is missing in your connector's pom.xml");
        }
        return RepositoryId.createFromUrl((String)url);
    }

    public static RepositoryId getRepository(String owner, String name) throws RepositoryCreationException {
        if (StringUtils.isBlank((String)owner)) {
            throw new RepositoryCreationException("Error creating the repository: repositoryOwner is missing. repositoryName is specified so repositoryOwner must also be specified");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new RepositoryCreationException("Error creating the repository: repositoryName is missing. repositoryOwner is specified so repositoryName must also be specified");
        }
        return RepositoryId.create((String)owner, (String)name);
    }

    public static GitHubClient createClient(String host, String userName, String password) throws RepositoryCreationException {
        GitHubClient client = !StringUtils.isEmpty((String)host) ? new GitHubClient(host) : new GitHubClient();
        if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)password)) {
            throw new RepositoryCreationException("No authentication credentials configured");
        }
        client.setCredentials(userName, password);
        return client;
    }

    public static Commit createCommit(RepositoryId repository, DataService service, Commit commit) throws GithubException {
        Commit created;
        try {
            created = service.createCommit((IRepositoryIdProvider)repository, commit);
        }
        catch (IOException e) {
            throw new GithubException("Error creating commit: " + e.getMessage(), e);
        }
        return created;
    }

    public static Reference getReference(RepositoryId repository, DataService service, String branch) throws RepositoryCreationException {
        Reference ref = null;
        try {
            ref = service.getReference((IRepositoryIdProvider)repository, branch);
        }
        catch (RequestException e) {
            if (404 != e.getStatus()) {
                throw new RepositoryCreationException("Error getting reference: " + e.getMessage(), (Exception)((Object)e));
            }
        }
        catch (IOException e) {
            throw new RepositoryCreationException("Error getting reference: " + e.getMessage(), e);
        }
        if (ref != null && !ref.getObject().getType().equals("commit")) {
            throw new RepositoryCreationException(MessageFormat.format("Existing ref {0} points to a {1} ({2}) instead of a commmit", ref.getRef(), ref.getObject().getType(), ref.getObject().getSha()));
        }
        return ref;
    }

    public static List<TreeModel> getTreeFromUrl(String user, String password, String url) throws GithubRequestException {
        GithubRestcall githubRestcall = new GithubRestcall();
        JSONArray treeArray = (JSONArray)new JSONObject(githubRestcall.authorizedGithubRequest(user, password, url)).get("tree");
        Type listType = new TypeToken<ArrayList<TreeModel>>(){}.getType();
        Gson mapper = new Gson();
        return (List)mapper.fromJson(treeArray.toString(), listType);
    }

    public static void checkBranchIsCreated(String repositoryName, String repositoryOwner, String branchName, String user, String password, boolean merge) throws GithubRequestException {
        List<String> branchesNames;
        if (merge && !(branchesNames = RepositoryUtils.getRepoBranches(repositoryOwner, repositoryName, user, password)).contains(branchName)) {
            merge = false;
        }
    }

    public static List<String> getRepoBranches(String repositoryOwner, String repositoryName, String user, String password) throws GithubRequestException {
        String url = "https://api.github.com/repos/" + repositoryOwner + "/" + repositoryName + "/branches";
        GithubRestcall githubRestcall = new GithubRestcall();
        JSONArray branches = new JSONArray(githubRestcall.authorizedGithubRequest(user, password, url));
        ArrayList<String> branchesNames = new ArrayList<String>();
        for (int i = 0; i < branches.length(); ++i) {
            JSONObject branch = (JSONObject)branches.get(0);
            branchesNames.add(branch.getString("name"));
        }
        return branchesNames;
    }

    public static String getRepositoryNameFromUrl(String repositoryUrl) {
        return repositoryUrl.substring(repositoryUrl.lastIndexOf("/") + 1);
    }

    public static String getRepositoryOwnerFromUrl(String repositoryUrl) {
        String repositoryOwner = repositoryUrl.substring(0, repositoryUrl.lastIndexOf("/"));
        return repositoryOwner.substring(repositoryOwner.lastIndexOf("/") + 1);
    }
}

