/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.egit.github.core.Blob;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Reference;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.Tree;
import org.eclipse.egit.github.core.TreeEntry;
import org.eclipse.egit.github.core.TypedResource;
import org.eclipse.egit.github.core.service.DataService;
import org.eclipse.egit.github.core.util.EncodingUtils;
import org.mule.devkit.tooling.FIleUtils;
import org.mule.devkit.tooling.RepositoryManager;
import org.mule.devkit.tooling.exceptions.BlobCreationException;
import org.mule.devkit.tooling.exceptions.GithubException;
import org.mule.devkit.tooling.exceptions.GithubRequestException;
import org.mule.devkit.tooling.exceptions.IndexGenerationException;
import org.mule.devkit.tooling.github.model.TreeModel;
import org.mule.devkit.tooling.html.generation.IndexBuilder;

public class GithubManager {
    private static final int BUFFER_LENGTH = 8192;
    private DataService service;
    private RepositoryId repoId;
    private Reference ref;
    private Boolean shouldMerge;

    public GithubManager(DataService service, RepositoryId repoId, Reference ref, Boolean merge) {
        this.service = service;
        this.repoId = repoId;
        this.ref = ref;
        this.shouldMerge = merge;
    }

    public Tree writeTree(List<TreeEntry> entries, Log log) throws GithubException {
        Tree tree;
        log.info((CharSequence)MessageFormat.format("Creating a tree with {0} blob entries", entries.size()));
        String baseTree = null;
        try {
            if (this.shouldMerge.booleanValue() && this.ref != null) {
                Tree currentTree = this.service.getCommit((IRepositoryIdProvider)this.repoId, this.ref.getObject().getSha()).getTree();
                if (currentTree != null) {
                    baseTree = currentTree.getSha();
                }
                log.info((CharSequence)MessageFormat.format("Merging with tree {0}", baseTree));
            }
            tree = this.service.createTree((IRepositoryIdProvider)this.repoId, entries, baseTree);
        }
        catch (IOException e) {
            throw new GithubException("Error creating tree: " + e.getMessage(), e);
        }
        return tree;
    }

    public TreeEntry createIndexHtmlBlob(List<String> versions, String docLink, String projectName, Map<String, List<String>> map) throws BlobCreationException {
        IndexBuilder indexBuilder = new IndexBuilder(versions, docLink, projectName, map);
        File indexHtml = null;
        try {
            indexHtml = indexBuilder.generateHtmlFile();
        }
        catch (IndexGenerationException e) {
            e.printStackTrace();
            throw new BlobCreationException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BlobCreationException(e.getMessage());
        }
        return this.createTreeEntry(indexHtml, "index.html");
    }

    public TreeEntry createBlobFromResourceFile(String fileName, String suffix) throws BlobCreationException {
        File file;
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/" + fileName + suffix);
        try {
            file = File.createTempFile(fileName, suffix);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BlobCreationException(e.getMessage());
        }
        try {
            FileUtils.copyInputStreamToFile((InputStream)resourceAsStream, (File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.createTreeEntry(file, fileName + suffix);
    }

    public List<TreeEntry> createBlobs(String[] paths, String prefix, File baseDir, List<TreeEntry> entries, Log log) throws BlobCreationException {
        log.info((CharSequence)MessageFormat.format("Creating {0} blobs", paths.length));
        for (String path : paths) {
            TreeEntry entry = this.createTreeEntry(this.repoId, this.service, baseDir, path, prefix);
            entries.add(entry);
        }
        return entries;
    }

    public void updateReference(Commit commit, Commit created, Log log) throws GithubException {
        TypedResource object = new TypedResource();
        object.setType("commit").setSha(created.getSha());
        if (this.ref != null) {
            this.ref.setObject(object);
            try {
                log.info((CharSequence)MessageFormat.format("Updating reference {0} from {1} to {2}", "refs/heads/gh-pages", ((Commit)commit.getParents().get(0)).getSha(), created.getSha()));
                this.service.editReference((IRepositoryIdProvider)this.repoId, this.ref, true);
            }
            catch (IOException e) {
                throw new GithubException("Error editing reference: " + e.getMessage(), e);
            }
        }
        this.ref = new Reference().setObject(object).setRef("refs/heads/gh-pages");
        try {
            log.info((CharSequence)MessageFormat.format("Creating reference {0} starting at commit {1}", "refs/heads/gh-pages", created.getSha()));
            this.service.createReference((IRepositoryIdProvider)this.repoId, this.ref);
        }
        catch (IOException e) {
            throw new GithubException("Error creating reference: " + e.getMessage(), e);
        }
    }

    public String createBlob(String path, File directory) throws BlobCreationException {
        File file = new File(directory, path);
        return this.createBlob(file);
    }

    public String createBlob(File file) throws BlobCreationException {
        long length = file.length();
        int size = length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length;
        ByteArrayOutputStream output = new ByteArrayOutputStream(size);
        FileInputStream stream = null;
        try {
            int read;
            stream = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            while ((read = stream.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            try {
                throw new BlobCreationException("Error reading file: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        Blob blob = new Blob().setEncoding("base64");
        blob.setContent(EncodingUtils.toBase64((byte[])output.toByteArray()));
        try {
            return this.uploadBlobRetryIfError(blob);
        }
        catch (GithubException e) {
            throw new BlobCreationException("Error creating blob: " + e.getMessage(), e);
        }
    }

    public String uploadBlobRetryIfError(Blob blob) throws GithubException {
        for (int i = 0; i < 3; ++i) {
            try {
                String resultBlob = this.service.createBlob((IRepositoryIdProvider)this.repoId, blob);
                return resultBlob;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        throw new GithubException("Cannot upload documentation to GitHub after retrying");
    }

    public TreeEntry createTreeEntry(RepositoryId repository, DataService service, File file, String fileSpecificPath, String prefix) throws BlobCreationException {
        TreeEntry entry = new TreeEntry();
        entry.setPath(prefix + fileSpecificPath);
        entry.setType("blob");
        entry.setMode("100644");
        String blob = null;
        blob = !prefix.isEmpty() ? this.createBlob(fileSpecificPath, file) : this.createBlob(file);
        entry.setSha(blob);
        return entry;
    }

    public TreeEntry createTreeEntry(File file, String name) throws BlobCreationException {
        return this.createTreeEntry(this.repoId, this.service, file, name, "");
    }

    public List<String> getAllDocumentationVersions(String version, String user, String password, boolean merge) throws GithubRequestException {
        ArrayList<String> versions = new ArrayList<String>();
        if (merge) {
            List<TreeModel> treeList;
            try {
                String url = this.service.getCommit((IRepositoryIdProvider)this.repoId, this.ref.getObject().getSha()).getTree().getUrl();
                treeList = RepositoryManager.getTreeFromUrl(user, password, url);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new GithubRequestException(e.getMessage(), e);
            }
            for (TreeModel tree : treeList) {
                String path = tree.getPath();
                if (path.contains("index") || path.equals(version)) continue;
                versions.add(path);
            }
        }
        versions.add(version);
        Comparator comparator = Collections.reverseOrder();
        Collections.sort(versions, comparator);
        return versions;
    }

    public Map<String, List<String>> getDemosNames(File demosDirectory, String version, String user, String password, boolean merge) throws GithubRequestException {
        ArrayList<String> demos = new ArrayList<String>();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String path : FIleUtils.getZipFiles(demosDirectory)) {
            path = path.substring(path.lastIndexOf(File.separator) + 1);
            demos.add(path);
        }
        map.put(version, demos);
        if (merge) {
            String url;
            try {
                url = this.service.getCommit((IRepositoryIdProvider)this.repoId, this.ref.getObject().getSha()).getTree().getUrl();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new GithubRequestException(e.getMessage(), e);
            }
            List<TreeModel> treeList = RepositoryManager.getTreeFromUrl(user, password, url);
            for (TreeModel versionTree : treeList) {
                demos = new ArrayList();
                if (versionTree.getPath().contains("index")) continue;
                List<TreeModel> demoTrees = RepositoryManager.getTreeFromUrl(user, password, versionTree.getUrl());
                for (TreeModel demoTree : demoTrees) {
                    if (!demoTree.getPath().equals("demo")) continue;
                    List<TreeModel> finalTree = RepositoryManager.getTreeFromUrl(user, password, demoTree.getUrl());
                    for (TreeModel tree : finalTree) {
                        String path = tree.getPath();
                        if (!path.endsWith(".zip")) continue;
                        demos.add(path);
                    }
                    map.put(versionTree.getPath(), demos);
                }
            }
        }
        return map;
    }
}

