/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling.html.generation;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.mule.devkit.tooling.exceptions.IndexGenerationException;
import org.rendersnake.HtmlAttributesFactory;
import org.rendersnake.HtmlCanvas;
import org.rendersnake.Renderable;
import org.rendersnake.internal.CharactersWriteable;

public class IndexBuilder
implements Renderable {
    List<String> versions;
    String docUrl;
    String connectorName;
    Map<String, List<String>> map;

    public IndexBuilder(List<String> versions, String docUrl, String connectorName, Map<String, List<String>> map) {
        this.versions = versions;
        this.docUrl = docUrl;
        this.connectorName = connectorName;
        this.map = map;
    }

    public void renderOn(HtmlCanvas html) throws IOException {
        html.html().head().title().content(this.connectorName).link((CharactersWriteable)HtmlAttributesFactory.rel((String)"stylesheet").type("text/css").href("//maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css")).link((CharactersWriteable)HtmlAttributesFactory.rel((String)"stylesheet").type("text/css").href("index.css")).link((CharactersWriteable)HtmlAttributesFactory.rel((String)"stylesheet").type("text/css").href("http://fonts.googleapis.com/css?family=Ubuntu:regular,bold&subset=Latin"))._head().body();
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"middle")).div((CharactersWriteable)HtmlAttributesFactory.class_((String)"left-side")).img((CharactersWriteable)HtmlAttributesFactory.src((String)"index.png").class_("main-image"))._div().div((CharactersWriteable)HtmlAttributesFactory.class_((String)"right-side")).h1((CharactersWriteable)HtmlAttributesFactory.class_((String)"title")).content(this.connectorName).table((CharactersWriteable)HtmlAttributesFactory.class_((String)"title-table")).tr().th((CharactersWriteable)HtmlAttributesFactory.class_((String)"version")).content("Version").th((CharactersWriteable)HtmlAttributesFactory.class_((String)"apidoc")).content("ApiDoc").th((CharactersWriteable)HtmlAttributesFactory.class_((String)"samples")).content("Samples")._tr()._table().table((CharactersWriteable)HtmlAttributesFactory.class_((String)"versions-table"));
        for (String version : this.versions) {
            String url = "http://" + this.docUrl + "/" + version;
            html.tr().td((CharactersWriteable)HtmlAttributesFactory.class_((String)"version")).div((CharactersWriteable)HtmlAttributesFactory.style((String)"")).content(version)._td().td((CharactersWriteable)HtmlAttributesFactory.class_((String)"apidoc")).a((CharactersWriteable)HtmlAttributesFactory.href((String)url)).div().i((CharactersWriteable)HtmlAttributesFactory.class_((String)"fa fa-file-text fa-lg"))._i()._div()._a()._td().td((CharactersWriteable)HtmlAttributesFactory.class_((String)"samples"));
            List<String> demos = this.map.get(version);
            if (demos != null && !demos.isEmpty()) {
                html.div((CharactersWriteable)HtmlAttributesFactory.id((String)"dd").class_("wrapper-dropdown-5").tabindex("1")).write("Download").ul((CharactersWriteable)HtmlAttributesFactory.class_((String)"dropdown"));
                for (String demo : demos) {
                    html.write("").li().write("").a((CharactersWriteable)HtmlAttributesFactory.href((String)(url + "/demo/" + demo))).write("").div((CharactersWriteable)HtmlAttributesFactory.style((String)"")).content(demo)._a()._li();
                }
                html._ul().content("");
            } else {
                html.div((CharactersWriteable)HtmlAttributesFactory.style((String)"")).content("no samples");
            }
            html._td()._tr();
        }
        html._table()._div()._div()._body()._html();
    }

    public File generateHtmlFile() throws IOException, IndexGenerationException {
        File index = new File("index.html");
        String html = this.buildAsString();
        FileUtils.writeStringToFile((File)index, (String)html);
        return index;
    }

    public String buildAsString() throws IndexGenerationException {
        HtmlCanvas html = new HtmlCanvas();
        try {
            this.renderOn(html);
        }
        catch (IOException e) {
            throw new IndexGenerationException(e.getMessage());
        }
        return html.toHtml();
    }
}

