/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.util.DirectoryScanner;

public class FIleUtils {
    private static String ZIP_SUFFIX = ".zip";

    public static String[] removeEmpties(String ... values) {
        if (values == null || values.length == 0) {
            return new String[0];
        }
        ArrayList<String> validValues = new ArrayList<String>();
        for (String value : values) {
            if (value == null || value.length() <= 0) continue;
            validValues.add(value);
        }
        return validValues.toArray(new String[validValues.size()]);
    }

    public static String[] getMatchingPaths(String[] includes, String[] excludes, String baseDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir);
        if (includes != null && includes.length > 0) {
            scanner.setIncludes(includes);
        }
        if (excludes != null && excludes.length > 0) {
            scanner.setExcludes(excludes);
        }
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public static String getPrefix(String prefix) {
        if (prefix == null) {
            return "";
        }
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
            return prefix;
        }
        return null;
    }

    public static String[] getFilesToInclude(File baseDirectory, String[] includes, String[] excludes) {
        String baseDir = baseDirectory.getAbsolutePath();
        String[] includePaths = FIleUtils.removeEmpties(includes);
        String[] excludePaths = FIleUtils.removeEmpties(excludes);
        return FIleUtils.getMatchingPaths(includePaths, excludePaths, baseDir);
    }

    public static String[] getFilesToInclude(File baseDirectory) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDirectory.getAbsolutePath());
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public static String[] getZipFiles(File baseDirectory) {
        ArrayList<String> zipFiles = new ArrayList<String>();
        for (File file : baseDirectory.listFiles()) {
            String path = file.getAbsolutePath();
            if (!FIleUtils.isZipFile(path)) continue;
            path = path.substring(path.lastIndexOf("/") + 1);
            zipFiles.add(path);
        }
        return zipFiles.toArray(new String[zipFiles.size()]);
    }

    public static void compressAllFoldersInside(File directory) {
        File[] demos = directory.listFiles();
        if (demos == null) {
            return;
        }
        for (File demo : demos) {
            if (!demo.isDirectory()) continue;
            FIleUtils.zipFolder(demo);
        }
    }

    private static void zipFolder(File directory) {
        byte[] buffer = new byte[1024];
        try {
            FileOutputStream fos = new FileOutputStream(directory + ZIP_SUFFIX);
            ZipOutputStream zos = new ZipOutputStream(fos);
            List<String> fileList = FIleUtils.generateFileList(directory, new ArrayList<String>());
            for (String file : fileList) {
                int len;
                ZipEntry ze = new ZipEntry(FIleUtils.removeUserDirFromPath(file));
                zos.putNextEntry(ze);
                FileInputStream in = new FileInputStream(file);
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                in.close();
            }
            zos.closeEntry();
            zos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static List<String> generateFileList(File node, List<String> fileList) {
        if (node.isFile()) {
            fileList.add(node.getAbsolutePath());
        }
        if (node.isDirectory()) {
            String[] subNode;
            for (String filename : subNode = node.list()) {
                FIleUtils.generateFileList(new File(node, filename), fileList);
            }
        }
        return fileList;
    }

    private static String removeUserDirFromPath(String filePath) {
        return filePath.replace(System.getProperty("user.dir") + "/demo/", "");
    }

    private static boolean isZipFile(String file) {
        return file.endsWith(ZIP_SUFFIX);
    }

    public static void removeAllZipFiles(File directory) {
        for (File file : directory.listFiles()) {
            if (!FIleUtils.isZipFile(file.getAbsolutePath())) continue;
            FileUtils.deleteQuietly((File)file);
        }
    }
}

