/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.CommitUser;
import org.eclipse.egit.github.core.Reference;
import org.eclipse.egit.github.core.Tree;
import org.eclipse.egit.github.core.TreeEntry;
import org.eclipse.egit.github.core.service.DataService;
import org.mule.devkit.tooling.FIleUtils;
import org.mule.devkit.tooling.GithubManager;
import org.mule.devkit.tooling.RepositoryManager;
import org.mule.devkit.tooling.exceptions.BlobCreationException;
import org.mule.devkit.tooling.exceptions.GithubException;
import org.mule.devkit.tooling.exceptions.GithubRequestException;
import org.mule.devkit.tooling.exceptions.RepositoryCreationException;

@Mojo(name="deploy")
public class GitHubPagesMojo
extends AbstractMojo {
    private static final String HOST = "api.github.com";
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(property="docsDirectory", defaultValue="${project.build.directory}/apidocs", required=true)
    private File docsDirectory;
    @Parameter(property="demosDirectory", defaultValue="${project.basedir}/demo")
    private File demosDirectory;
    @Parameter(required=true, property="version", defaultValue="${project.version}")
    private String version;
    @Parameter(defaultValue="${project.scm.url}")
    private String repositoryUrl;
    @Parameter(property="includes")
    private String[] includes;
    @Parameter(property="excludes")
    private String[] excludes = new String[]{"**/current.xml"};
    @Parameter(required=true, defaultValue="true", property="merge")
    private boolean merge;
    @Parameter(defaultValue="Connector Documentation Deploy", property="message")
    private String message;
    @Parameter(required=true, property="user")
    private String user;
    @Parameter(required=true, property="password")
    private String password;
    @Parameter(property="repositoryOwner")
    private String repositoryOwner;
    @Parameter(property="repositoryName")
    private String repositoryName;
    private RepositoryManager repo;
    private DataService service;
    private Reference ref;
    private GithubManager ghManager;
    private Log log;

    public void execute() throws MojoExecutionException {
        if (this.version.contains("SNAPSHOT")) {
            throw new MojoExecutionException("version can not be a SNAPSHOT");
        }
        this.log = this.getLog();
        try {
            this.repo = new RepositoryManager(this.repositoryName, this.repositoryOwner, this.repositoryUrl);
            this.service = new DataService(this.repo.createClient(HOST, this.user, this.password));
            this.ref = this.repo.getReference(this.service);
            this.ghManager = new GithubManager(this.service, this.repo.getRepository(), this.ref, this.merge);
        }
        catch (RepositoryCreationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        try {
            this.merge = this.repo.checkBranchIsCreated(this.user, this.password, this.merge);
            List<TreeEntry> entries = new ArrayList<TreeEntry>();
            if (this.demosDirectory.exists()) {
                FIleUtils.compressAllFoldersInside(this.demosDirectory);
                this.ghManager.createBlobs(FIleUtils.getZipFiles(this.demosDirectory), FIleUtils.getPrefix(this.version) + "demo/", this.demosDirectory, entries, this.log);
            } else {
                this.log.warn((CharSequence)"/demo directory does exists.");
            }
            Map<String, List<String>> demosMap = this.ghManager.getDemosNames(this.demosDirectory, this.version, this.user, this.password, this.merge);
            List<String> versions = this.ghManager.getAllDocumentationVersions(this.version, this.user, this.password, this.merge);
            entries.add(this.ghManager.createIndexHtmlBlob(versions, this.getDocLink(), this.project.getName(), demosMap));
            entries.add(this.ghManager.createBlobFromResourceFile("index", ".js"));
            entries.add(this.ghManager.createBlobFromResourceFile("index", ".css"));
            entries.add(this.ghManager.createBlobFromResourceFile("index", ".png"));
            entries = this.ghManager.createBlobs(FIleUtils.getFilesToInclude(this.docsDirectory, this.includes, this.excludes), FIleUtils.getPrefix(this.version), this.docsDirectory, entries, this.log);
            Tree tree = this.ghManager.writeTree(entries, this.log);
            CommitUser committer = this.repo.getCommitUser(this.user);
            Commit commit = this.repo.buildCommit(tree, committer, this.message);
            if (this.ref != null) {
                commit.setParents(Collections.singletonList(new Commit().setSha(this.ref.getObject().getSha())));
            }
            Commit created = this.repo.createCommit(this.service, commit);
            this.log.info((CharSequence)MessageFormat.format("Creating commit with SHA-1: {0}", created.getSha()));
            this.ghManager.updateReference(commit, created, this.log);
        }
        catch (BlobCreationException | GithubException | GithubRequestException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        FIleUtils.removeAllZipFiles(this.demosDirectory);
    }

    public String getDocLink() {
        return String.format("%s.github.io/%s", this.repo.getRepositoryOwner(), this.repo.getRepositoryName());
    }
}

