/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.TreeEntry;
import org.mule.devkit.tooling.GithubManager;
import org.mule.devkit.tooling.ProjectFileUtils;
import org.mule.devkit.tooling.blob.builder.ApiDocsBlobBuilder;
import org.mule.devkit.tooling.blob.builder.BaseBlobBuilder;
import org.mule.devkit.tooling.blob.builder.DemoBlobBuilder;
import org.mule.devkit.tooling.blob.builder.FunctionalBlobBuilder;
import org.mule.devkit.tooling.blob.builder.IndexBlobBuilder;
import org.mule.devkit.tooling.blob.builder.ResourcesBlobBuilder;
import org.mule.devkit.tooling.exceptions.GithubException;

@Mojo(name="deploy")
public class GitHubPagesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(property="docsDir", defaultValue="${project.build.directory}/apidocs", required=true)
    private File docsDir;
    @Parameter(property="functionalDocsDirectory", defaultValue="${project.basedir}/doc")
    private File functionalDocsDir;
    @Parameter(property="demosDir", defaultValue="${project.basedir}/demo")
    private File demosDir;
    @Parameter(required=true, property="version", defaultValue="${project.version}")
    private String version;
    @Parameter(required=true, property="functionalFileName", defaultValue="user-manual.adoc")
    private String functionalFileName;
    @Parameter(required=true, property="skipFunctional", defaultValue="false")
    private Boolean skipFunctional;
    @Parameter(defaultValue="${project.scm.url}")
    private String repoURL;
    @Parameter(required=true, defaultValue="true", property="merge")
    private boolean merge;
    @Parameter(property="repoOwner")
    private String repoOwner;
    @Parameter(property="repoName")
    private String repoName;
    private GithubManager github;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        this.verify(log);
        try {
            System.console().printf("Github username: ", new Object[0]);
            String user = System.console().readLine();
            System.console().printf("Password: ", new Object[0]);
            String password = new String(System.console().readPassword());
            this.github = new GithubManager(this.repoName, this.repoOwner, this.repoURL, user, password, this.merge);
            Commit created = this.github.createCommit(this.github.writeTree(this.getEntries(log), log));
            this.github.updateReference(created, log);
        }
        catch (GithubException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            ProjectFileUtils.removeAllZipFiles(this.demosDir);
        }
    }

    public void verify(Log log) throws MojoExecutionException {
        log.info((CharSequence)"Starting verification");
        if (this.version.contains("SNAPSHOT")) {
            throw new MojoExecutionException("version cannot be SNAPSHOT");
        }
        if (!this.skipFunctional.booleanValue() && !new File(this.project.getBasedir() + "/doc/" + this.functionalFileName).exists()) {
            throw new MojoExecutionException(this.functionalFileName + " does not exist under the /doc folder, Functional documentation cannot be generated without a file");
        }
        log.info((CharSequence)"Verification passed");
    }

    private List<TreeEntry> getEntries(Log log) throws GithubException {
        ArrayList<TreeEntry> entries = new ArrayList<TreeEntry>();
        ArrayList<BaseBlobBuilder> builders = new ArrayList<BaseBlobBuilder>();
        builders.add(new FunctionalBlobBuilder(this.project.getBasedir(), this.skipFunctional));
        builders.add(new ApiDocsBlobBuilder(this.docsDir));
        builders.add(new ResourcesBlobBuilder());
        builders.add(new DemoBlobBuilder(this.demosDir));
        builders.add(new IndexBlobBuilder(this.demosDir, this.project.getName(), this.functionalFileName, this.skipFunctional));
        for (BaseBlobBuilder builder : builders) {
            builder.createBlobs(this.github, entries, this.version, log);
        }
        return entries;
    }
}

