/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.egit.github.core.Blob;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.CommitUser;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Reference;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.Tree;
import org.eclipse.egit.github.core.TreeEntry;
import org.eclipse.egit.github.core.TypedResource;
import org.eclipse.egit.github.core.service.DataService;
import org.eclipse.egit.github.core.util.EncodingUtils;
import org.mule.devkit.tooling.ProjectFileUtils;
import org.mule.devkit.tooling.RepositoryManager;
import org.mule.devkit.tooling.exceptions.BlobCreationException;
import org.mule.devkit.tooling.exceptions.GithubException;
import org.mule.devkit.tooling.exceptions.RepositoryCreationException;

public final class GithubManager {
    private static final String HOST = "api.github.com";
    private static final int BUFFER_LENGTH = 8192;
    private Boolean merge;
    private RepositoryManager repoManager;
    private DataService service;
    private Reference reference;
    private String user;

    public GithubManager(String repositoryName, String repositoryOwner, String repositoryUrl, String user, String password, Boolean merge) throws GithubException {
        try {
            this.repoManager = new RepositoryManager(repositoryName, repositoryOwner, repositoryUrl);
        }
        catch (RepositoryCreationException e) {
            throw new GithubException(e.getMessage(), e);
        }
        this.service = new DataService(this.repoManager.createClient(HOST, user, password));
        this.reference = this.obtainReference();
        this.merge = this.shouldMerge(merge);
        this.user = user;
    }

    public Tree writeTree(List<TreeEntry> entries, Log log) throws GithubException {
        Tree tree;
        log.info((CharSequence)"--------------------------------------------");
        log.info((CharSequence)MessageFormat.format("Creating a tree with {0} blob entries", entries.size()));
        log.info((CharSequence)"--------------------------------------------");
        String baseTree = null;
        try {
            if (this.merge.booleanValue() && this.reference != null) {
                Tree currentTree = this.service.getCommit((IRepositoryIdProvider)this.repoManager.getRepositoryId(), this.reference.getObject().getSha()).getTree();
                if (currentTree != null) {
                    baseTree = currentTree.getSha();
                }
                log.info((CharSequence)MessageFormat.format("Merging with tree {0}", baseTree));
            }
            tree = this.service.createTree((IRepositoryIdProvider)this.repoManager.getRepositoryId(), entries, baseTree);
        }
        catch (IOException e) {
            throw new GithubException("Error creating tree: " + e.getMessage(), e);
        }
        return tree;
    }

    public void updateReference(Commit created, Log log) throws GithubException {
        TypedResource object = new TypedResource();
        object.setType("commit").setSha(created.getSha());
        try {
            if (this.reference != null) {
                this.reference.setObject(object);
                log.info((CharSequence)MessageFormat.format("Updating reference {0} to {1}", "refs/heads/gh-pages", created.getSha()));
                this.service.editReference((IRepositoryIdProvider)this.repoManager.getRepositoryId(), this.reference, true);
            } else {
                this.reference = new Reference().setObject(object).setRef("refs/heads/gh-pages");
                log.info((CharSequence)MessageFormat.format("Creating new reference: {0}", "refs/heads/gh-pages"));
                this.service.createReference((IRepositoryIdProvider)this.repoManager.getRepositoryId(), this.reference);
            }
        }
        catch (IOException e) {
            throw new GithubException("Error creating reference: " + e.getMessage(), e);
        }
    }

    public List<TreeEntry> createBlobs(String[] paths, String prefix, File baseDir, List<TreeEntry> entries, Log log) throws GithubException {
        for (String path : paths) {
            path = path.replace("\\", "/");
            log.info((CharSequence)MessageFormat.format("Creating blob for: {0}", path));
            TreeEntry entry = this.createTreeEntry(baseDir, path, prefix);
            entries.add(entry);
        }
        return entries;
    }

    public String createBlob(String path, File directory) throws BlobCreationException {
        File file = new File(directory, path);
        return this.createBlob(file);
    }

    public String createBlob(File file) throws BlobCreationException {
        long length = file.length();
        int size = length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length;
        ByteArrayOutputStream output = new ByteArrayOutputStream(size);
        FileInputStream stream = null;
        try {
            int read;
            stream = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            while ((read = stream.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            try {
                throw new BlobCreationException("Error reading file: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        Blob blob = new Blob().setEncoding("base64");
        blob.setContent(EncodingUtils.toBase64((byte[])output.toByteArray()));
        try {
            return this.uploadBlobRetryIfError(blob);
        }
        catch (GithubException e) {
            throw new BlobCreationException("Error Uploading blobs: " + e.getMessage(), e);
        }
    }

    public String uploadBlobRetryIfError(Blob blob) throws GithubException {
        int maxTries = 10;
        for (int i = 0; i <= maxTries; ++i) {
            try {
                if (i == maxTries) {
                    Thread.sleep(500L);
                }
                return this.service.createBlob((IRepositoryIdProvider)this.repoManager.getRepositoryId(), blob);
            }
            catch (IOException | InterruptedException ignored) {
                continue;
            }
        }
        throw new GithubException("Cannot upload documentation to GitHub after retrying several times");
    }

    public TreeEntry createTreeEntry(File file, String filePath, String prefix) throws GithubException {
        TreeEntry entry = new TreeEntry();
        entry.setPath(prefix + filePath);
        entry.setType("blob");
        entry.setMode("100644");
        try {
            String blob = !prefix.isEmpty() ? this.createBlob(filePath, file) : this.createBlob(file);
            entry.setSha(blob);
        }
        catch (BlobCreationException e) {
            throw new GithubException(e.getMessage(), e);
        }
        return entry;
    }

    public TreeEntry createTreeEntry(File file, String name) throws GithubException {
        return this.createTreeEntry(file, name, "");
    }

    public SortedMap<String, List<String>> getVersionsWithDemos(File demosDirectory, String versionNumber, RepositoryId repo) throws GithubException {
        ArrayList<String> demos = new ArrayList<String>();
        TreeMap<String, List<String>> versionsMap = new TreeMap<String, List<String>>(Collections.reverseOrder());
        for (String path : ProjectFileUtils.getZipFiles(demosDirectory)) {
            path = path.substring(path.lastIndexOf(File.separator) + 1);
            demos.add(path);
        }
        versionsMap.put(versionNumber, demos);
        if (this.merge.booleanValue()) {
            try {
                Tree tree = this.service.getTree((IRepositoryIdProvider)repo, this.reference.getObject().getSha());
                ArrayList<TreeEntry> versionsTree = new ArrayList<TreeEntry>();
                for (TreeEntry versionEntry : tree.getTree()) {
                    if (versionEntry.getPath().contains("index") || versionEntry.getPath().equals(versionNumber)) continue;
                    versionsTree.add(versionEntry);
                }
                for (TreeEntry version : versionsTree) {
                    demos = new ArrayList();
                    for (TreeEntry entry : this.service.getTree((IRepositoryIdProvider)repo, version.getSha()).getTree()) {
                        if (entry.getPath().endsWith("demo")) {
                            for (TreeEntry treeEntry : this.service.getTree((IRepositoryIdProvider)repo, entry.getSha()).getTree()) {
                                if (treeEntry.getPath().startsWith(".") || !treeEntry.getPath().endsWith(".zip")) continue;
                                demos.add(treeEntry.getPath());
                            }
                            versionsMap.put(version.getPath(), demos);
                            continue;
                        }
                        versionsMap.put(version.getPath(), demos);
                    }
                }
            }
            catch (Exception e) {
                throw new GithubException("Could not retrieve all the previous versions", e);
            }
        }
        return versionsMap;
    }

    public Reference obtainReference() throws GithubException {
        Reference ref;
        block3: {
            ref = null;
            try {
                ref = this.service.getReference((IRepositoryIdProvider)this.repoManager.getRepositoryId(), "refs/heads/gh-pages");
            }
            catch (Exception e) {
                if (e.getMessage().contains("404")) break block3;
                throw new GithubException("Error getting reference: " + e.getMessage(), e);
            }
        }
        if (ref != null && !ref.getObject().getType().equals("commit")) {
            throw new GithubException(MessageFormat.format("Existing reference {0} points to a {1} instead of a commmit", ref.getRef(), ref.getObject().getType()));
        }
        return ref;
    }

    public RepositoryId getRepository() {
        return this.repoManager.getRepositoryId();
    }

    public Commit createCommit(Tree tree) throws GithubException {
        CommitUser committer = this.repoManager.getCommitUser(this.user);
        Commit commit = this.repoManager.buildCommit(tree, committer);
        if (this.reference != null) {
            commit.setParents(Collections.singletonList(new Commit().setSha(this.reference.getObject().getSha())));
        }
        return this.repoManager.createCommit(this.service, commit);
    }

    private Boolean shouldMerge(Boolean merge) throws GithubException {
        try {
            for (Reference reference : this.service.getReferences((IRepositoryIdProvider)this.repoManager.getRepositoryId())) {
                if (!reference.getRef().contains("gh-pages") || !merge.booleanValue()) continue;
                return true;
            }
        }
        catch (IOException e) {
            throw new GithubException(e.getMessage(), e);
        }
        return false;
    }

    public String getDocLink() {
        return String.format("%s.github.io/%s", this.repoManager.getRepositoryOwner(), this.repoManager.getRepositoryName());
    }
}

