/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.util.DirectoryScanner;

public class ProjectFileUtils {
    private static String ZIP_SUFFIX = ".zip";

    public static String getPrefix(String prefix) {
        if (prefix == null) {
            return "";
        }
        if (prefix.length() > 0 && !prefix.endsWith(File.separator)) {
            prefix = prefix + "/";
            return prefix;
        }
        return null;
    }

    public static String[] getFilesToInclude(File baseDirectory) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDirectory.getAbsolutePath());
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public static String[] getZipFiles(File baseDirectory) {
        if (!baseDirectory.exists()) {
            return new String[0];
        }
        ArrayList<String> zipFiles = new ArrayList<String>();
        for (File file : baseDirectory.listFiles()) {
            String path = file.getAbsolutePath();
            if (!ProjectFileUtils.isZipFile(path)) continue;
            path = path.substring(path.lastIndexOf(File.separator) + 1);
            zipFiles.add(path);
        }
        return zipFiles.toArray(new String[zipFiles.size()]);
    }

    public static void zipDemos(File directory) {
        if (directory.listFiles() != null) {
            for (File demo : directory.listFiles()) {
                if (!demo.isDirectory()) continue;
                ProjectFileUtils.zipDemo(demo);
            }
        }
    }

    private static void zipDemo(File directory) {
        byte[] buffer = new byte[1024];
        try {
            FileOutputStream fos = new FileOutputStream(directory + ZIP_SUFFIX);
            ZipOutputStream zos = new ZipOutputStream(fos);
            List<String> fileList = ProjectFileUtils.generateFileList(directory, new ArrayList<String>());
            for (String file : fileList) {
                int len;
                ZipEntry ze = new ZipEntry(file.substring(file.lastIndexOf("demo" + File.separator) + 1));
                zos.putNextEntry(ze);
                FileInputStream in = new FileInputStream(file);
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                in.close();
            }
            zos.closeEntry();
            zos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static List<String> generateFileList(File node, List<String> fileList) {
        if (node.isFile()) {
            fileList.add(node.getAbsolutePath());
        }
        if (node.isDirectory()) {
            String[] subNode;
            for (String filename : subNode = node.list()) {
                ProjectFileUtils.generateFileList(new File(node, filename), fileList);
            }
        }
        return fileList;
    }

    private static boolean isZipFile(String file) {
        return file.endsWith(ZIP_SUFFIX);
    }

    public static void removeAllZipFiles(File directory) {
        if (directory.listFiles() != null) {
            for (File file : directory.listFiles()) {
                if (!ProjectFileUtils.isZipFile(file.getAbsolutePath())) continue;
                FileUtils.deleteQuietly((File)file);
            }
        }
    }
}

