/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling;

import java.io.IOException;
import java.util.Calendar;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.CommitUser;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.Tree;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.DataService;
import org.eclipse.egit.github.core.service.UserService;
import org.mule.devkit.tooling.exceptions.GithubException;
import org.mule.devkit.tooling.exceptions.RepositoryCreationException;

public class RepositoryManager {
    public static final String BRANCH_NAME = "gh-pages";
    public static final String BRANCH_DEFAULT = "refs/heads/gh-pages";
    private RepositoryId repository;
    private String repositoryName;
    private String repositoryOwner;

    public RepositoryManager(String repositoryName, String repositoryOwner, String repositoryUrl) throws RepositoryCreationException {
        if (this.useScm(repositoryName, repositoryOwner)) {
            if (StringUtils.isBlank((String)repositoryUrl) || repositoryUrl.contains("mule-devkit-parent")) {
                throw new RepositoryCreationException("There is no SCM declared in your pom.xml. No RepositoryName or RepositoryOwner found");
            }
            this.repository = this.getRepository(repositoryUrl);
            this.repositoryName = this.getRepositoryNameFromUrl(repositoryUrl);
            this.repositoryOwner = this.getRepositoryOwnerFromUrl(repositoryUrl);
        } else {
            this.repository = this.getRepository(repositoryOwner, repositoryName);
            this.repositoryName = repositoryName;
            this.repositoryOwner = repositoryOwner;
        }
    }

    public Commit buildCommit(Tree tree, CommitUser committer) {
        Commit commit = new Commit();
        commit.setMessage("Connector Documentation Deploy");
        commit.setTree(tree);
        commit.setAuthor(committer);
        commit.setCommitter(committer);
        return commit;
    }

    public CommitUser getCommitUser(String user) throws GithubException {
        CommitUser committer = new CommitUser();
        try {
            User current = new UserService().getUser(user);
            committer.setDate(Calendar.getInstance().getTime());
            committer.setName(current.getName());
            String email = current.getEmail();
            if (StringUtils.isBlank((String)email)) {
                email = "no@email.com";
            }
            committer.setEmail(email);
        }
        catch (IOException e) {
            throw new GithubException("Error retrieving github user information: " + e.getMessage(), e);
        }
        return committer;
    }

    public Commit createCommit(DataService service, Commit commit) throws GithubException {
        Commit created;
        try {
            created = service.createCommit((IRepositoryIdProvider)this.repository, commit);
        }
        catch (IOException e) {
            throw new GithubException("Error creating commit: " + e.getMessage(), e);
        }
        return created;
    }

    private RepositoryId getRepository(String url) throws RepositoryCreationException {
        if (StringUtils.isBlank((String)url)) {
            throw new RepositoryCreationException("Url is null. url attribute in scm is missing in your connector's pom.xml");
        }
        return RepositoryId.createFromUrl((String)url);
    }

    private RepositoryId getRepository(String owner, String name) throws RepositoryCreationException {
        RepositoryId repositoryId;
        if (StringUtils.isBlank((String)owner)) {
            throw new RepositoryCreationException("Error creating the repository: repositoryOwner is missing. repositoryName is specified so repositoryOwner must also be specified");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new RepositoryCreationException("Error creating the repository: repositoryName is missing. repositoryOwner is specified so repositoryName must also be specified");
        }
        try {
            repositoryId = RepositoryId.create((String)owner, (String)name);
        }
        catch (Exception e) {
            throw new RepositoryCreationException("Error while creating the repository", e);
        }
        return repositoryId;
    }

    public GitHubClient createClient(String host, String userName, String password) throws GithubException {
        GitHubClient client = !StringUtils.isEmpty((String)host) ? new GitHubClient(host) : new GitHubClient();
        if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)password)) {
            throw new GithubException("No authentication credentials configured");
        }
        client.setCredentials(userName, password);
        return client;
    }

    public String getRepositoryNameFromUrl(String repositoryUrl) {
        return repositoryUrl.substring(repositoryUrl.lastIndexOf("/") + 1);
    }

    public String getRepositoryOwnerFromUrl(String repositoryUrl) {
        String owner = repositoryUrl.substring(0, repositoryUrl.lastIndexOf("/"));
        return owner.substring(owner.lastIndexOf("/") + 1);
    }

    public boolean useScm(String repositoryName, String repositoryOwner) {
        return StringUtils.isEmpty((String)repositoryName) && StringUtils.isEmpty((String)repositoryOwner);
    }

    public RepositoryId getRepositoryId() {
        return this.repository;
    }

    public String getRepositoryOwner() {
        return this.repositoryOwner;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }
}

