/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling.blob.builder;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.eclipse.egit.github.core.TreeEntry;
import org.mule.devkit.tooling.GithubManager;
import org.mule.devkit.tooling.ProjectFileUtils;
import org.mule.devkit.tooling.blob.builder.BaseBlobBuilder;
import org.mule.devkit.tooling.exceptions.GithubException;
import org.mule.devkit.tooling.html.generation.AsciidoctorPluginRequestBuilder;

public class FunctionalBlobBuilder
implements BaseBlobBuilder {
    private boolean skipFunctional;
    private File projectBaseDir;

    public FunctionalBlobBuilder(File projectBaseDir, Boolean skipFunctional) {
        this.skipFunctional = skipFunctional;
        this.projectBaseDir = projectBaseDir;
    }

    @Override
    public void createBlobs(GithubManager github, List<TreeEntry> entries, String version, Log log) throws GithubException {
        if (!this.skipFunctional) {
            this.generateFunctionalDoc();
            File generatedDocDir = new File(String.format("%s%starget%sfunctional", this.projectBaseDir.getAbsolutePath(), File.separator, File.separator));
            github.createBlobs(ProjectFileUtils.getFilesToInclude(generatedDocDir), ProjectFileUtils.getPrefix(version) + "functional/", generatedDocDir, entries, log);
        } else {
            log.info((CharSequence)"--------------------------------------------");
            log.info((CharSequence)"Skipped functional documentation generation");
            log.info((CharSequence)"--------------------------------------------");
        }
    }

    private void generateFunctionalDoc() throws GithubException {
        try {
            AsciidoctorPluginRequestBuilder asciidocGenerator = new AsciidoctorPluginRequestBuilder();
            asciidocGenerator.addProperty("connector.dir", this.projectBaseDir.getAbsolutePath());
            asciidocGenerator.executeInvocationRequest();
        }
        catch (MavenInvocationException e) {
            throw new GithubException("Could not generate the functional documentation", (Exception)((Object)e));
        }
    }
}

