/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling.blob.builder;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.egit.github.core.TreeEntry;
import org.mule.devkit.tooling.GithubManager;
import org.mule.devkit.tooling.blob.builder.BaseBlobBuilder;
import org.mule.devkit.tooling.exceptions.GithubException;
import org.mule.devkit.tooling.exceptions.HtmlGenerationException;
import org.mule.devkit.tooling.html.generation.IndexBuilder;

public class IndexBlobBuilder
implements BaseBlobBuilder {
    private File demosDirectory;
    private String projectName;
    private String asciidocFileName;
    private Boolean skip;

    public IndexBlobBuilder(File demosDirectory, String projectName, String asciidocFileName, Boolean skip) {
        this.demosDirectory = demosDirectory;
        this.projectName = projectName;
        this.asciidocFileName = asciidocFileName;
        this.skip = skip;
    }

    @Override
    public void createBlobs(GithubManager github, List<TreeEntry> entries, String version, Log log) throws GithubException {
        try {
            log.info((CharSequence)"Creating blob for index.html file");
            IndexBuilder indexBuilder = new IndexBuilder(github.getDocLink(), this.projectName, github.getVersionsWithDemos(this.demosDirectory, version, github.getRepository()), this.asciidocFileName, this.skip);
            File indexHtml = indexBuilder.generateHtmlFile();
            entries.add(github.createTreeEntry(indexHtml, "index.html"));
        }
        catch (IOException | HtmlGenerationException e) {
            throw new GithubException("Could not generated index.html page", e);
        }
    }
}

