/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling.blob.builder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.egit.github.core.TreeEntry;
import org.mule.devkit.tooling.GithubManager;
import org.mule.devkit.tooling.blob.builder.BaseBlobBuilder;
import org.mule.devkit.tooling.exceptions.GithubException;

public class ResourcesBlobBuilder
implements BaseBlobBuilder {
    private static final String[] RESOURCE_FILES = new String[]{"index.png", "index.js", "index.css"};

    @Override
    public void createBlobs(GithubManager github, List<TreeEntry> entries, String version, Log log) throws GithubException {
        for (String resourceFile : RESOURCE_FILES) {
            File file;
            log.info((CharSequence)MessageFormat.format("Creating blob for resource file: {0}", resourceFile));
            try {
                file = File.createTempFile(resourceFile.substring(0, resourceFile.indexOf(".")), resourceFile.substring(resourceFile.indexOf(".")));
                InputStream resourceAsStream = this.getClass().getResourceAsStream("/" + resourceFile);
                FileUtils.copyInputStreamToFile((InputStream)resourceAsStream, (File)file);
            }
            catch (IOException e) {
                throw new GithubException("Could not generate Resource File Blob", e);
            }
            entries.add(github.createTreeEntry(file, resourceFile));
        }
    }
}

