/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.tooling.html.generation;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.mule.devkit.tooling.exceptions.HtmlGenerationException;
import org.rendersnake.HtmlAttributesFactory;
import org.rendersnake.HtmlCanvas;
import org.rendersnake.Renderable;
import org.rendersnake.internal.CharactersWriteable;

public class IndexBuilder
implements Renderable {
    String docUrl;
    String connectorName;
    Map<String, List<String>> versions;
    String functionalFile;
    Boolean skipFunctional;

    public IndexBuilder(String docUrl, String connectorName, Map<String, List<String>> versions, String functionalFile, Boolean skipFunctional) {
        this.docUrl = docUrl;
        this.connectorName = connectorName;
        this.versions = versions;
        this.functionalFile = functionalFile;
        this.skipFunctional = skipFunctional;
    }

    public void renderOn(HtmlCanvas html) throws IOException {
        html.html().head().title().content(this.connectorName).link((CharactersWriteable)HtmlAttributesFactory.rel((String)"stylesheet").type("text/css").href("//maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css")).link((CharactersWriteable)HtmlAttributesFactory.rel((String)"stylesheet").type("text/css").href("index.css")).link((CharactersWriteable)HtmlAttributesFactory.rel((String)"stylesheet").type("text/css").href("http://fonts.googleapis.com/css?family=Ubuntu:regular,bold&subset=Latin"))._head().body();
        html.div((CharactersWriteable)HtmlAttributesFactory.id((String)"content")).div((CharactersWriteable)HtmlAttributesFactory.id((String)"left"))._div().div((CharactersWriteable)HtmlAttributesFactory.id((String)"right")).div((CharactersWriteable)HtmlAttributesFactory.class_((String)"center-content")).h1((CharactersWriteable)HtmlAttributesFactory.class_((String)"title")).content(this.connectorName).table((CharactersWriteable)HtmlAttributesFactory.class_((String)"custom-table")).tr().th((CharactersWriteable)HtmlAttributesFactory.class_((String)"version")).content("Version").th((CharactersWriteable)HtmlAttributesFactory.class_((String)"apidoc")).content("ApiDoc").th((CharactersWriteable)HtmlAttributesFactory.class_((String)"apidoc")).content("Functional Doc").th((CharactersWriteable)HtmlAttributesFactory.class_((String)"samples")).content("Samples")._tr();
        for (String version : this.versions.keySet()) {
            String url = "http://" + this.docUrl + "/" + version;
            html.tr().td((CharactersWriteable)HtmlAttributesFactory.class_((String)"version")).div((CharactersWriteable)HtmlAttributesFactory.style((String)"")).content(version)._td().td((CharactersWriteable)HtmlAttributesFactory.class_((String)"apidoc")).a((CharactersWriteable)HtmlAttributesFactory.href((String)url)).div().i((CharactersWriteable)HtmlAttributesFactory.class_((String)"fa fa-book fa-lg"))._i()._div()._a()._td().td((CharactersWriteable)HtmlAttributesFactory.class_((String)"apidoc"));
            if (!this.skipFunctional.booleanValue()) {
                html.a((CharactersWriteable)HtmlAttributesFactory.href((String)(url + "/functional/" + this.functionalFile.replace("adoc", "html")))).div().i((CharactersWriteable)HtmlAttributesFactory.class_((String)"fa fa-file-text fa-lg"))._i()._div()._a();
            }
            html._td().td((CharactersWriteable)HtmlAttributesFactory.class_((String)"samples"));
            List<String> demos = this.versions.get(version);
            if (!demos.isEmpty()) {
                html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"dropdown ddmenu")).write("Download").ul();
                for (String demo : demos) {
                    html.write("").li().write("").a((CharactersWriteable)HtmlAttributesFactory.href((String)(url + "/demo/" + demo))).write("").div((CharactersWriteable)HtmlAttributesFactory.style((String)"")).content(demo)._a()._li();
                }
                html._ul().content("");
            } else {
                html.div((CharactersWriteable)HtmlAttributesFactory.style((String)"")).content("no samples");
            }
            html._td()._tr();
        }
        html._table()._div()._div()._div()._body()._html();
        html.script((CharactersWriteable)HtmlAttributesFactory.src((String)"http://codepen.io/assets/libs/fullpage/jquery.js"))._script();
        html.script((CharactersWriteable)HtmlAttributesFactory.type((String)"text/javascript").src("index.js"))._script();
    }

    public File generateHtmlFile() throws IOException, HtmlGenerationException {
        File index = File.createTempFile("index", ".html");
        String html = this.buildAsString();
        FileUtils.writeStringToFile((File)index, (String)html);
        return index;
    }

    public String buildAsString() throws HtmlGenerationException {
        HtmlCanvas html = new HtmlCanvas();
        try {
            this.renderOn(html);
        }
        catch (IOException e) {
            throw new HtmlGenerationException(e.getMessage());
        }
        return html.toHtml();
    }
}

