/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.factories;

import java.util.List;
import java.util.ServiceLoader;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.api.transaction.TypedTransactionFactory;
import org.mule.runtime.core.processor.TryMessageProcessor;
import org.mule.runtime.core.transaction.MuleTransactionConfig;
import org.mule.runtime.core.transaction.TransactionType;
import org.springframework.beans.factory.FactoryBean;

public class TryProcessorFactoryBean
extends AbstractAnnotatedObject
implements FactoryBean {
    protected List messageProcessors;
    protected MessagingExceptionHandler exceptionListener;
    protected String transactionalAction;
    private TransactionType transactionType;

    public Class getObjectType() {
        return MessageProcessorChain.class;
    }

    public void setMessageProcessors(List messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public Object getObject() throws Exception {
        TryMessageProcessor txProcessor = new TryMessageProcessor();
        txProcessor.setAnnotations(this.getAnnotations());
        txProcessor.setExceptionListener(this.exceptionListener);
        txProcessor.setTransactionConfig(this.createTransactionConfig(this.transactionalAction, this.transactionType));
        txProcessor.setMessageProcessors(this.messageProcessors);
        return txProcessor;
    }

    protected MuleTransactionConfig createTransactionConfig(String action, TransactionType type) {
        MuleTransactionConfig transactionConfig = new MuleTransactionConfig();
        transactionConfig.setActionAsString(action);
        transactionConfig.setFactory(this.lookUpTransactionFactory(type));
        return transactionConfig;
    }

    private TransactionFactory lookUpTransactionFactory(TransactionType type) {
        for (TypedTransactionFactory possibleFactory : ServiceLoader.load(TypedTransactionFactory.class)) {
            if (!type.equals((Object)possibleFactory.getType())) continue;
            try {
                return (TransactionFactory)possibleFactory.getClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Unable to generate a factory for transaction %s.", new Object[]{type})));
            }
        }
        throw new IllegalArgumentException(String.format("No factory available for transaction type %s", new Object[]{type}));
    }

    public boolean isSingleton() {
        return false;
    }

    public void setExceptionListener(MessagingExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public void setTransactionalAction(String action) {
        this.transactionalAction = action;
    }

    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }
}

