/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.config.bootstrap;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.core.config.bootstrap.BootstrapException;
import org.mule.runtime.core.config.bootstrap.RegistryBootstrapDiscoverer;

public class ClassLoaderRegistryBootstrapDiscoverer
implements RegistryBootstrapDiscoverer {
    public static final String BOOTSTRAP_PROPERTIES = "META-INF/org/mule/runtime/core/config/registry-bootstrap.properties";
    private final ClassLoader classLoader;

    public ClassLoaderRegistryBootstrapDiscoverer(ClassLoader classLoader) {
        Preconditions.checkArgument(classLoader != null, "Classloader cannot be null");
        this.classLoader = classLoader;
    }

    @Override
    public List<Properties> discover() throws BootstrapException {
        try {
            return PropertiesUtils.discoverProperties(this.classLoader, BOOTSTRAP_PROPERTIES);
        }
        catch (IOException e) {
            throw new BootstrapException(I18nMessageFactory.createStaticMessage("Could not load properties file"), (Throwable)e);
        }
    }
}

