/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.config.builders;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.ParentMuleContextAwareConfigurationBuilder;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.core.config.ConfigResource;
import org.mule.runtime.core.config.bootstrap.ArtifactType;
import org.mule.runtime.core.config.builders.AbstractResourceConfigurationBuilder;
import org.mule.runtime.core.config.i18n.CoreMessages;

public class AutoConfigurationBuilder
extends AbstractResourceConfigurationBuilder
implements ParentMuleContextAwareConfigurationBuilder {
    private final ArtifactType artifactType;
    private MuleContext parentContext;

    public AutoConfigurationBuilder(String resource, Map<String, String> artifactProperties, ArtifactType artifactType) throws ConfigurationException {
        super(resource, artifactProperties);
        this.artifactType = artifactType;
    }

    public AutoConfigurationBuilder(String[] resources, Map<String, String> artifactProperties, ArtifactType artifactType) throws ConfigurationException {
        super(resources, artifactProperties);
        this.artifactType = artifactType;
    }

    public AutoConfigurationBuilder(ConfigResource[] resources, Map<String, String> artifactProperties, ArtifactType artifactType) {
        super(resources, artifactProperties);
        this.artifactType = artifactType;
    }

    @Override
    protected void doConfigure(MuleContext muleContext) throws ConfigurationException {
        this.autoConfigure(muleContext, this.artifactConfigResources);
    }

    protected void autoConfigure(MuleContext muleContext, ConfigResource[] resources) throws ConfigurationException {
        LinkedHashMap<String, ArrayList<ConfigResource>> configsMap = new LinkedHashMap<String, ArrayList<ConfigResource>>();
        for (ConfigResource resource : resources) {
            String configExtension = StringUtils.substringAfterLast((String)resource.getUrl().getPath(), (String)".");
            ArrayList<ConfigResource> configs = (ArrayList<ConfigResource>)configsMap.get(configExtension);
            if (configs == null) {
                configs = new ArrayList<ConfigResource>();
                configsMap.put(configExtension, configs);
            }
            configs.add(resource);
        }
        try {
            Properties props = PropertiesUtils.loadProperties(ClassUtils.getResource("configuration-builders.properties", this.getClass()).openStream());
            for (Map.Entry e : configsMap.entrySet()) {
                String extension = (String)e.getKey();
                List configs = (List)e.getValue();
                String className = (String)props.get(extension);
                if (className == null || !ClassUtils.isClassOnPath(className, this.getClass())) {
                    throw new ConfigurationException(CoreMessages.configurationBuilderNoMatching(this.createConfigResourcesString()));
                }
                ConfigResource[] constructorArg = new ConfigResource[configs.size()];
                System.arraycopy(configs.toArray(), 0, constructorArg, 0, configs.size());
                ConfigurationBuilder cb = (ConfigurationBuilder)ClassUtils.instantiateClass(className, new Object[]{constructorArg, this.getArtifactProperties(), this.artifactType});
                if (this.parentContext != null && cb instanceof ParentMuleContextAwareConfigurationBuilder) {
                    ((ParentMuleContextAwareConfigurationBuilder)cb).setParentContext(this.parentContext);
                } else if (this.parentContext != null) {
                    throw new MuleRuntimeException(CoreMessages.createStaticMessage(String.format("ConfigurationBuilder %s does not support domain context", cb.getClass().getCanonicalName())));
                }
                cb.configure(muleContext);
            }
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public void setParentContext(MuleContext parentContext) {
        this.parentContext = parentContext;
    }
}

