/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.exception;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.EnrichedNotificationInfo;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.context.notification.ErrorHandlerNotification;
import org.mule.runtime.core.exception.AbstractExceptionListener;
import org.mule.runtime.core.exception.DisjunctiveErrorTypeMatcher;
import org.mule.runtime.core.exception.ErrorTypeMatcher;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.internal.message.DefaultExceptionPayload;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.processor.AbstractRequestResponseMessageProcessor;
import org.mule.runtime.core.routing.requestreply.ReplyToPropertyRequestReplyReplier;
import org.mule.runtime.core.transaction.TransactionCoordination;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public abstract class TemplateOnErrorHandler
extends AbstractExceptionListener
implements MessagingExceptionHandlerAcceptor {
    private MessageProcessorChain configuredMessageProcessors;
    private Processor replyToMessageProcessor = new ReplyToPropertyRequestReplyReplier();
    private String errorType = null;
    private ErrorTypeMatcher errorTypeMatcher = null;
    private String when;
    private boolean handleException;

    @Override
    public final Event handleException(MessagingException exception, Event event) {
        try {
            return new ExceptionMessageProcessor(exception, this.muleContext, this.flowConstruct).process(event);
        }
        catch (MuleException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Publisher<Event> apply(MessagingException exception) {
        Publisher<Event> publisher = new ExceptionMessageProcessor(exception, this.muleContext, this.flowConstruct).apply((Publisher<Event>)Mono.just((Object)exception.getEvent()));
        return Mono.from(publisher).handle((event, sink) -> {
            if (exception.handled()) {
                sink.next(event);
            } else {
                exception.setProcessedEvent((Event)event);
                sink.error((Throwable)exception);
            }
        });
    }

    @Override
    public void setMessageProcessors(List<Processor> processors) {
        super.setMessageProcessors(processors);
        this.configuredMessageProcessors = MessageProcessors.newChain(this.getMessageProcessors());
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return this.configuredMessageProcessors == null ? new ArrayList() : Collections.singletonList(this.configuredMessageProcessors);
    }

    private void markExceptionAsHandledIfRequired(Exception exception) {
        if (this.handleException) {
            this.markExceptionAsHandled(exception);
        }
    }

    protected void markExceptionAsHandled(Exception exception) {
        if (exception instanceof MessagingException) {
            ((MessagingException)exception).setHandled(true);
        }
    }

    protected Event processReplyTo(Event event, Exception e) {
        try {
            return this.replyToMessageProcessor.process(event);
        }
        catch (MuleException ex) {
            this.logFatal(event, ex);
            return event;
        }
    }

    protected Event nullifyExceptionPayloadIfRequired(Event event) {
        if (this.handleException) {
            return Event.builder(event).error(null).message(InternalMessage.builder(event.getMessage()).exceptionPayload(null).build()).build();
        }
        return event;
    }

    private void processStatistics() {
        FlowConstructStatistics statistics = this.flowConstruct.getStatistics();
        if (statistics != null && statistics.isEnabled()) {
            statistics.incExecutionError();
        }
    }

    protected Publisher<Event> routeAsync(Event event, MessagingException t) {
        if (!this.getMessageProcessors().isEmpty()) {
            event = Event.builder(event).message(InternalMessage.builder(event.getMessage()).exceptionPayload(new DefaultExceptionPayload(t)).build()).build();
            return this.configuredMessageProcessors.apply((Publisher<Event>)Mono.just((Object)event));
        }
        return Mono.just((Object)event);
    }

    @Override
    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        super.doInitialise(muleContext);
        if (this.configuredMessageProcessors != null) {
            this.configuredMessageProcessors.setFlowConstruct(this.flowConstruct);
            this.configuredMessageProcessors.setMuleContext(muleContext);
            this.configuredMessageProcessors.setMessagingExceptionHandler(this.messagingExceptionHandler);
        }
        this.errorTypeMatcher = this.createErrorType();
    }

    private ErrorTypeMatcher createErrorType() {
        if (this.errorType == null) {
            return null;
        }
        String[] errorTypeIdentifiers = this.errorType.split(",");
        List<ErrorTypeMatcher> matchers = Arrays.stream(errorTypeIdentifiers).map(identifier -> {
            String parsedIdentifier = identifier.trim();
            Optional<ErrorType> optional = this.muleContext.getErrorTypeRepository().lookupErrorType(ComponentIdentifier.buildFromStringRepresentation(parsedIdentifier));
            ErrorType errorType = optional.orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not found ErrorType for the given identifier: '%s'", parsedIdentifier)));
            return new SingleErrorTypeMatcher(errorType);
        }).collect(Collectors.toList());
        return new DisjunctiveErrorTypeMatcher(matchers);
    }

    public void setWhen(String when) {
        this.when = when;
    }

    @Override
    public boolean accept(Event event) {
        return this.acceptsAll() || this.acceptsErrorType(event) || this.when != null && this.muleContext.getExpressionManager().evaluateBoolean(this.when, event, this.flowConstruct);
    }

    private boolean acceptsErrorType(Event event) {
        return this.errorTypeMatcher != null && this.errorTypeMatcher.match(event.getError().get().getErrorType());
    }

    @Override
    public boolean acceptsAll() {
        return this.errorTypeMatcher == null && this.when == null;
    }

    protected Event afterRouting(MessagingException exception, Event event) {
        return event;
    }

    protected Event beforeRouting(MessagingException exception, Event event) {
        return event;
    }

    @Override
    public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
    }

    public void setHandleException(boolean handleException) {
        this.handleException = handleException;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    private class ExceptionMessageProcessor
    extends AbstractRequestResponseMessageProcessor {
        private MessagingException exception;

        public ExceptionMessageProcessor(final MessagingException exception, MuleContext muleContext, FlowConstruct flowConstruct) {
            this.exception = exception;
            this.setMuleContext(muleContext);
            this.setFlowConstruct(flowConstruct);
            this.next = new Processor(){

                @Override
                public Event process(Event event) throws MuleException {
                    if (!TemplateOnErrorHandler.this.getMessageProcessors().isEmpty()) {
                        Event newEvent = Event.builder(event).message(InternalMessage.builder(event.getMessage()).exceptionPayload(new DefaultExceptionPayload(exception)).build()).build();
                        return TemplateOnErrorHandler.this.configuredMessageProcessors.process(newEvent);
                    }
                    return event;
                }

                @Override
                public Publisher<Event> apply(Publisher<Event> publisher) {
                    return Mono.from(publisher).flatMapMany(event -> MessageProcessors.processWithChildContext(event, p -> Mono.from((Publisher)p).flatMapMany(childEvent -> Mono.from(TemplateOnErrorHandler.this.routeAsync((Event)childEvent, exception)))));
                }
            };
        }

        @Override
        protected Event processRequest(Event request) throws MuleException {
            this.muleContext.getNotificationManager().fireNotification(new ErrorHandlerNotification(EnrichedNotificationInfo.createInfo(request, this.exception, TemplateOnErrorHandler.this.configuredMessageProcessors), this.flowConstruct, 2001));
            TemplateOnErrorHandler.this.fireNotification(this.exception, request);
            TemplateOnErrorHandler.this.logException(this.exception, request);
            TemplateOnErrorHandler.this.processStatistics();
            TemplateOnErrorHandler.this.markExceptionAsHandledIfRequired(this.exception);
            return TemplateOnErrorHandler.this.beforeRouting(this.exception, request);
        }

        @Override
        protected Event processResponse(Event response) throws MuleException {
            if ((response = TemplateOnErrorHandler.this.afterRouting(this.exception, response)) != null) {
                response = TemplateOnErrorHandler.this.processReplyTo(response, this.exception);
                TemplateOnErrorHandler.this.closeStream(response.getMessage());
                return TemplateOnErrorHandler.this.nullifyExceptionPayloadIfRequired(response);
            }
            return response;
        }

        @Override
        protected Event processCatch(Event event, MessagingException exception) throws MessagingException {
            try {
                exception.setInErrorHandler(true);
                this.logger.error("Exception during exception strategy execution");
                TemplateOnErrorHandler.this.doLogException(exception);
                TransactionCoordination.getInstance().rollbackCurrentTransaction();
            }
            catch (Exception ex) {
                this.logger.warn(ex.getMessage());
            }
            throw exception;
        }

        @Override
        protected void processFinally(Event event, MessagingException exception) {
            this.muleContext.getNotificationManager().fireNotification(new ErrorHandlerNotification(EnrichedNotificationInfo.createInfo(event, exception, TemplateOnErrorHandler.this.configuredMessageProcessors), this.flowConstruct, 2002));
        }
    }
}

