/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.retry.notifiers;

import org.mule.runtime.core.api.retry.RetryContext;
import org.mule.runtime.core.api.retry.RetryNotifier;
import org.mule.runtime.core.config.ExceptionHelper;
import org.mule.runtime.core.context.notification.ConnectionNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectNotifier
implements RetryNotifier {
    protected final transient Logger logger = LoggerFactory.getLogger(ConnectNotifier.class);

    @Override
    public void onSuccess(RetryContext context) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Successfully connected to " + context.getDescription());
        }
        this.fireConnectNotification(701, context.getDescription(), context);
    }

    @Override
    public void onFailure(RetryContext context, Throwable e) {
        this.fireConnectNotification(702, context.getDescription(), context);
        if (this.logger.isErrorEnabled()) {
            StringBuilder msg = new StringBuilder(512);
            msg.append("Failed to connect/reconnect: ").append(context.getDescription());
            Throwable t = ExceptionHelper.getRootException(e);
            msg.append(". Root Exception was: ").append(ExceptionHelper.writeException(t));
            if (this.logger.isTraceEnabled()) {
                t.printStackTrace();
            }
            this.logger.error(msg.toString());
        }
    }

    protected void fireConnectNotification(int action, String description, RetryContext context) {
        context.getMuleContext().fireNotification(new ConnectionNotification(null, description, action));
    }
}

