/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.transformer.AbstractTransformer;

public class StringAppendTransformer
extends AbstractTransformer {
    private String message = "";

    public StringAppendTransformer() {
        this("");
    }

    public StringAppendTransformer(String message) {
        this.message = message;
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.setReturnDataType(DataType.STRING);
    }

    @Override
    protected Object doTransform(Object src, Charset encoding) throws TransformerException {
        String string = src instanceof byte[] ? new String((byte[])src) : (src instanceof CursorStreamProvider ? this.handleStream((InputStream)((CursorStreamProvider)src).openCursor()) : (src instanceof InputStream ? this.handleStream((InputStream)src) : (String)src));
        return StringAppendTransformer.append(this.message, string);
    }

    private String handleStream(InputStream input) {
        String string;
        try {
            string = IOUtils.toString(input);
        }
        finally {
            IOUtils.closeQuietly(input);
        }
        return string;
    }

    public static String append(String append, String msg) {
        return msg + append;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

