/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.xmlsecurity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerFactory;
import net.sf.saxon.jaxp.SaxonTransformerFactory;
import org.mule.runtime.core.util.xmlsecurity.DefaultXMLSecureFactories;
import org.mule.runtime.core.util.xmlsecurity.XMLFactoryConfig;

public class XMLSecureFactoriesCache {
    private LoadingCache<XMLFactoryConfig, Object> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<XMLFactoryConfig, Object>(){

        public Object load(XMLFactoryConfig key) throws Exception {
            return key.createFactory();
        }
    });
    private static volatile XMLSecureFactoriesCache instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XMLSecureFactoriesCache getInstance() {
        if (instance != null) return instance;
        Class<XMLSecureFactoriesCache> clazz = XMLSecureFactoriesCache.class;
        synchronized (XMLSecureFactoriesCache.class) {
            if (instance != null) return instance;
            instance = new XMLSecureFactoriesCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private XMLSecureFactoriesCache() {
    }

    public DocumentBuilderFactory getDocumentBuilderFactory(Boolean externalEntities, Boolean expandEntities) {
        XMLFactoryConfig config = new XMLFactoryConfig(externalEntities, expandEntities, DocumentBuilderFactory.class.toString()){

            @Override
            public Object createFactory() {
                return DefaultXMLSecureFactories.createDocumentBuilderFactory(this.externalEntities, this.expandEntities);
            }
        };
        return (DocumentBuilderFactory)this.cache.getUnchecked((Object)config);
    }

    public SAXParserFactory getSAXParserFactory(Boolean externalEntities, Boolean expandEntities) {
        XMLFactoryConfig config = new XMLFactoryConfig(externalEntities, expandEntities, SAXParserFactory.class.toString()){

            @Override
            public Object createFactory() {
                return DefaultXMLSecureFactories.createSaxParserFactory(this.externalEntities, this.expandEntities);
            }
        };
        return (SAXParserFactory)this.cache.getUnchecked((Object)config);
    }

    public XMLInputFactory getXMLInputFactory(Boolean externalEntities, Boolean expandEntities) {
        XMLFactoryConfig config = new XMLFactoryConfig(externalEntities, expandEntities, XMLInputFactory.class.toString()){

            @Override
            public Object createFactory() {
                return DefaultXMLSecureFactories.createXmlInputFactory(this.externalEntities, this.expandEntities);
            }
        };
        return (XMLInputFactory)this.cache.getUnchecked((Object)config);
    }

    public TransformerFactory getTransformerFactory(Boolean externalEntities, Boolean expandEntities) {
        XMLFactoryConfig config = new XMLFactoryConfig(externalEntities, expandEntities, TransformerFactory.class.toString()){

            @Override
            public Object createFactory() {
                return DefaultXMLSecureFactories.createTransformerFactory(this.externalEntities, this.expandEntities);
            }
        };
        return (TransformerFactory)this.cache.getUnchecked((Object)config);
    }

    public TransformerFactory getSaxonTransformerFactory(Boolean externalEntities, Boolean expandEntities) {
        XMLFactoryConfig config = new XMLFactoryConfig(externalEntities, expandEntities, SaxonTransformerFactory.class.toString()){

            @Override
            public Object createFactory() {
                return DefaultXMLSecureFactories.createSaxonTransformerFactory(this.externalEntities, this.expandEntities);
            }
        };
        return (TransformerFactory)this.cache.getUnchecked((Object)config);
    }
}

