/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.descriptor;

import org.apache.commons.lang.StringUtils;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.descriptor.InvalidDependencyVersionException;

public class BundleDescriptorUtils {
    private BundleDescriptorUtils() {
    }

    public static boolean isCompatibleVersion(String availableVersion, String expectedVersion) {
        Version expected;
        Preconditions.checkArgument(!StringUtils.isEmpty((String)availableVersion), "availableVersion cannot be empty");
        Preconditions.checkArgument(!StringUtils.isEmpty((String)expectedVersion), "expectedVersion cannot be empty");
        if (availableVersion.equals(expectedVersion)) {
            return true;
        }
        Version available = BundleDescriptorUtils.getBundleVersion(availableVersion);
        if (available.compareTo((Object)(expected = BundleDescriptorUtils.getBundleVersion(expectedVersion))) >= 0) {
            String availableMajorVersion = BundleDescriptorUtils.getMajorVersion(availableVersion);
            String expectedMajorVersion = BundleDescriptorUtils.getMajorVersion(expectedVersion);
            return availableMajorVersion.equals(expectedMajorVersion);
        }
        return false;
    }

    private static String getMajorVersion(String version) {
        int index = version.indexOf(".");
        if (index < 0) {
            return version;
        }
        return version.substring(0, index);
    }

    private static Version getBundleVersion(String version) {
        try {
            return new GenericVersionScheme().parseVersion(version);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new InvalidDependencyVersionException("Unable to parse bundle version: " + version);
        }
    }
}

