/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.domain;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.internal.domain.DomainClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactoryUtils;
import org.mule.runtime.module.deployment.impl.internal.artifact.MuleContextListenerFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultMuleDomain;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainDescriptorParser;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainManager;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainWrapper;
import org.mule.runtime.module.deployment.impl.internal.domain.EmptyDomainDescriptor;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;
import org.mule.runtime.module.service.ServiceRepository;

public class DefaultDomainFactory
implements DomainFactory {
    private final DeployableArtifactClassLoaderFactory<DomainDescriptor> domainClassLoaderFactory;
    private final DomainManager domainManager;
    private final DomainDescriptorParser domainDescriptorParser;
    private final ClassLoaderRepository classLoaderRepository;
    private final ServiceRepository serviceRepository;
    private final ArtifactClassLoader containerClassLoader;
    private MuleContextListenerFactory muleContextListenerFactory;

    public DefaultDomainFactory(DeployableArtifactClassLoaderFactory<DomainDescriptor> domainClassLoaderFactory, DomainManager domainManager, ArtifactClassLoader containerClassLoader, ClassLoaderRepository classLoaderRepository, ServiceRepository serviceRepository) {
        this.classLoaderRepository = classLoaderRepository;
        Preconditions.checkArgument(domainManager != null, "Domain manager cannot be null");
        Preconditions.checkArgument(containerClassLoader != null, "Container classLoader cannot be null");
        Preconditions.checkArgument(serviceRepository != null, "Service repository cannot be null");
        this.containerClassLoader = containerClassLoader;
        this.domainClassLoaderFactory = domainClassLoaderFactory;
        this.domainManager = domainManager;
        this.domainDescriptorParser = new DomainDescriptorParser();
        this.serviceRepository = serviceRepository;
    }

    public void setMuleContextListenerFactory(MuleContextListenerFactory muleContextListenerFactory) {
        this.muleContextListenerFactory = muleContextListenerFactory;
    }

    @Override
    public Domain createArtifact(File domainLocation) throws IOException {
        String domainName = domainLocation.getName();
        Domain domain = this.domainManager.getDomain(domainName);
        if (domain != null) {
            throw new IllegalArgumentException(String.format("Domain '%s'  already exists", domainName));
        }
        if (domainName.contains(" ")) {
            throw new IllegalArgumentException("Mule domain name may not contain spaces: " + domainName);
        }
        DomainDescriptor descriptor = this.findDomain(domainName);
        DefaultMuleDomain defaultMuleDomain = new DefaultMuleDomain(descriptor, this.domainClassLoaderFactory.create(DomainClassLoaderFactory.getDomainId("default"), this.containerClassLoader, descriptor, Collections.emptyList()), this.classLoaderRepository, this.serviceRepository);
        if (this.muleContextListenerFactory != null) {
            defaultMuleDomain.setMuleContextListener(this.muleContextListenerFactory.create(descriptor.getName()));
        }
        DomainWrapper domainWrapper = new DomainWrapper(defaultMuleDomain, this);
        this.domainManager.addDomain(domainWrapper);
        return domainWrapper;
    }

    private DomainDescriptor findDomain(String domainName) throws IOException {
        if ("default".equals(domainName)) {
            return new EmptyDomainDescriptor(new File(MuleContainerBootstrapUtils.getMuleDomainsDir(), "default"));
        }
        File domainFolder = MuleFoldersUtil.getDomainFolder(domainName);
        File deploymentFile = ArtifactFactoryUtils.getDeploymentFile(domainFolder);
        DomainDescriptor descriptor = deploymentFile != null ? this.domainDescriptorParser.parse(domainFolder, deploymentFile, domainName) : new EmptyDomainDescriptor(new File(MuleContainerBootstrapUtils.getMuleDomainsDir(), domainName));
        return descriptor;
    }

    @Override
    public File getArtifactDir() {
        return MuleContainerBootstrapUtils.getMuleDomainsDir();
    }

    public void dispose(DomainWrapper domain) {
        this.domainManager.removeDomain(domain.getArtifactName());
    }

    public void start(DomainWrapper domainWrapper) {
        this.domainManager.addDomain(domainWrapper);
    }
}

