/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import java.util.Set;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataKeysContainerBuilder;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.metadata.resolving.QueryEntityResolver;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class EntityMetadataMediator {
    private final MetadataResolverFactory resolverFactory;

    public EntityMetadataMediator(OperationModel operationModel) {
        this.resolverFactory = MuleExtensionUtils.getMetadataResolverFactory(operationModel);
    }

    public MetadataResult<MetadataKeysContainer> getEntityKeys(MetadataContext context) {
        try {
            QueryEntityResolver queryEntityResolver = this.resolverFactory.getQueryEntityResolver();
            Set<MetadataKey> entityKeys = queryEntityResolver.getEntityKeys(context);
            MetadataKeysContainerBuilder keyBuilder = MetadataKeysContainerBuilder.getInstance();
            if (entityKeys.stream().anyMatch(key -> key.getChilds().size() > 0)) {
                return MetadataResult.failure(MetadataFailure.Builder.newFailure().withMessage("Error retrieving entity keys, Only single level keys are supported for entity metadata").withReason("There are at least one key that contains childs").withFailureCode(FailureCode.INVALID_METADATA_KEY).onKeys());
            }
            return MetadataResult.success(keyBuilder.add(queryEntityResolver.getResolverName(), entityKeys).build());
        }
        catch (Exception e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onKeys());
        }
    }

    public MetadataResult<TypeMetadataDescriptor> getEntityMetadata(MetadataContext context, MetadataKey entityKey) {
        try {
            MetadataType entityMetadata = this.resolverFactory.getQueryEntityResolver().getEntityMetadata(context, entityKey.getId());
            return MetadataResult.success(TypeMetadataDescriptor.builder().withType(entityMetadata).build());
        }
        catch (Exception e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onEntity());
        }
    }
}

